/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.metric;

import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.consumer.metric.MetricConfigManager;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.metric.Context;
import com.dianping.cat.report.page.metric.GraphCreator;
import com.dianping.cat.report.page.metric.Handler;
import com.dianping.cat.report.page.metric.JspViewer;
import com.dianping.cat.report.page.metric.Model;
import com.dianping.cat.report.page.metric.Payload;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private ProductLineConfigManager m_productLineConfigManager;
    @Inject
    private GraphCreator m_graphCreator;
    @Inject
    private MetricConfigManager m_metricConfigManager;

    private Map<String, LineChart> buildLineCharts(Payload payload, Date start, Date end) {
        Map allCharts = null;
        String productLine = payload.getProduct();
        if (StringUtils.isEmpty((String)productLine)) {
            String tag = payload.getTag();
            if (StringUtils.isEmpty((String)tag)) {
                tag = "\u4e1a\u52a1\u5927\u76d8";
                payload.setTag(tag);
            }
            allCharts = this.m_graphCreator.buildDashboardByTag(start, end, tag);
        } else {
            allCharts = this.m_graphCreator.buildChartsByProductLine(productLine, start, end);
        }
        return allCharts;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="metric")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="metric")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.normalize(model, payload);
        long date = payload.getDate();
        int timeRange = payload.getTimeRange();
        Date start = new Date(date - (long)(timeRange - 1) * 3600000L);
        Date end = new Date(date + 3600000L);
        Map allCharts = this.buildLineCharts(payload, start, end);
        switch (1.$SwitchMap$com$dianping$cat$report$page$metric$Action[payload.getAction().ordinal()]) {
            case 1: {
                model.setLineCharts(new ArrayList(allCharts.values()));
                break;
            }
            case 2: {
                String id = payload.getId();
                LineChart lineChart = (LineChart)allCharts.get(id);
                if (lineChart == null) break;
                model.setJson(lineChart.getJsonString());
            }
        }
        List tags = this.m_metricConfigManager.queryTags();
        model.setTags(tags);
        model.setProductLines(this.m_productLineConfigManager.queryMetricProductLines().values());
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.METRIC);
        model.setAction((Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        int timeRange = payload.getTimeRange();
        Date startTime = new Date(payload.getDate() - (long)(timeRange - 1) * 3600000L);
        Date endTime = new Date(payload.getDate() + 3600000L - 1L);
        model.setStartTime(startTime);
        model.setEndTime(endTime);
    }
}

