/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.metric.service;

import com.dianping.cat.consumer.metric.model.IEntity;
import com.dianping.cat.consumer.metric.model.IVisitor;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.cdn.graph.CdnReportConvertor;
import com.dianping.cat.report.page.metric.service.LocalMetricService;
import com.dianping.cat.report.page.metric.service.MetricReportMerger;
import com.dianping.cat.report.page.system.graph.SystemReportConvertor;
import com.dianping.cat.report.page.web.graph.WebReportConvertor;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.service.IpService;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalMetricService
extends LocalModelService<MetricReport> {
    public static final String ID = "metric";
    @Inject
    private ReportBucketManager m_bucketManager;
    @Inject
    private IpService m_ipService;

    public LocalMetricService() {
        super(ID);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        long startTime;
        List reports = super.getReport(period, domain);
        MetricReport report = null;
        if (reports != null) {
            report = new MetricReport(domain);
            MetricReportMerger merger = new MetricReportMerger(report);
            for (MetricReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getMetricItems().isEmpty()) && period.isLast() && (report = this.getReportFromLocalDisk(startTime = request.getStartTime(), domain)) == null) {
            report = new MetricReport(domain);
            report.setStartTime(new Date(startTime));
            report.setEndTime(new Date(startTime + 3600000L - 1L));
        }
        String metricType = payload.getMetricType();
        String type = payload.getType();
        if ("userMonitor".equals(metricType)) {
            String city = payload.getCity();
            String channel = payload.getChannel();
            WebReportConvertor convert = new WebReportConvertor(type, city, channel);
            convert.visitMetricReport(report);
            report = convert.getReport();
        } else if ("systemMonitor".equals(metricType)) {
            String ipAddrsStr = payload.getIpAddress();
            HashSet<String> ipAddrs = null;
            if (!"All".equalsIgnoreCase(ipAddrsStr)) {
                String[] ipAddrsArray = ipAddrsStr.split("_");
                ipAddrs = new HashSet<String>(Arrays.asList(ipAddrsArray));
            }
            SystemReportConvertor convert = new SystemReportConvertor(type, ipAddrs);
            convert.visitMetricReport(report);
            report = convert.getReport();
        } else if ("cdn".equals(metricType)) {
            String cdn = payload.getCdn();
            String province = payload.getProvince();
            String city = payload.getCity();
            CdnReportConvertor cdnReportConvertor = new CdnReportConvertor(this.m_ipService);
            cdnReportConvertor.setProvince(province).setCity(city).setCdn(cdn);
            cdnReportConvertor.visitMetricReport(report);
            report = cdnReportConvertor.getReport();
        }
        MetricReportFilter filter = new MetricReportFilter(payload.getMin(), payload.getMax());
        return filter.buildXml((IEntity)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        MetricReport report = new MetricReport(domain);
        MetricReportMerger merger = new MetricReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < 2; ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml == null) continue;
                MetricReport tmp = DefaultSaxParser.parse((String)xml);
                tmp.accept((IVisitor)merger);
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

