/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.metric.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.dal.BusinessReport;
import com.dianping.cat.consumer.dal.BusinessReportDao;
import com.dianping.cat.consumer.dal.BusinessReportEntity;
import com.dianping.cat.consumer.metric.model.IVisitor;
import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Point;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.consumer.metric.model.transform.DefaultNativeParser;
import com.dianping.cat.report.page.metric.service.MetricReportMerger;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricReportService
extends AbstractReportService<MetricReport> {
    @Inject
    private BusinessReportDao m_businessReportDao;

    public MetricReport makeReport(String domain, Date start, Date end) {
        MetricReport report = new MetricReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public MetricReport queryDailyReport(String domain, Date start, Date end) {
        throw new RuntimeException("Metric report don't support daily report");
    }

    public MetricReport queryHourlyReport(String group, Date start, Date end) {
        MetricReportMerger merger = new MetricReportMerger(new MetricReport(group));
        try {
            List reports = this.m_businessReportDao.findAllByPeriodProductLineName(start, group, BusinessReportEntity.READSET_FULL);
            for (BusinessReport report : reports) {
                byte[] content = report.getContent();
                try {
                    MetricReport reportModel = DefaultNativeParser.parse((byte[])content);
                    reportModel.accept((IVisitor)merger);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                    Cat.getProducer().logEvent("ErrorXML", "metric", "0", report.getProductLine() + " " + report.getPeriod() + " " + report.getId());
                }
            }
        }
        catch (DalNotFoundException e) {
            this.m_logger.warn(this.getClass().getSimpleName() + " " + group + " " + start + " " + end);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        MetricReport metricReport = merger.getMetricReport();
        metricReport.setStartTime(start);
        metricReport.setEndTime(new Date(end.getTime() - 1L));
        return this.transform(metricReport);
    }

    public MetricReport queryMonthlyReport(String domain, Date start) {
        throw new RuntimeException("Metric report don't support monthly report");
    }

    public MetricReport queryWeeklyReport(String domain, Date start) {
        throw new RuntimeException("Metric report don't support weekly report");
    }

    public MetricReport transform(MetricReport report) {
        Map items = report.getMetricItems();
        for (Map.Entry item : items.entrySet()) {
            MetricItem metricItem = (MetricItem)item.getValue();
            Map segs = metricItem.getSegments();
            if (segs.size() != 0) continue;
            Map oldPoints = metricItem.findOrCreateAbtest("-1").findOrCreateGroup("").getPoints();
            for (Point point : oldPoints.values()) {
                Segment seg = new Segment();
                seg.setId(point.getId());
                seg.setCount(point.getCount());
                seg.setAvg(point.getAvg());
                seg.setSum(point.getSum());
                segs.put(seg.getId(), seg);
            }
        }
        return report;
    }
}

