/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.metric.task;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.consumer.metric.MetricConfigManager;
import com.dianping.cat.consumer.metric.config.entity.MetricItemConfig;
import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.home.dal.report.Baseline;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.page.metric.service.BaselineService;
import com.dianping.cat.report.page.metric.service.MetricReportService;
import com.dianping.cat.report.page.metric.task.BaselineConfig;
import com.dianping.cat.report.page.metric.task.BaselineConfigManager;
import com.dianping.cat.report.page.metric.task.BaselineCreator;
import com.dianping.cat.report.page.metric.task.MetricPointParser;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricBaselineReportBuilder
implements TaskBuilder,
LogEnabled {
    public static final String ID = "metric";
    @Inject
    protected MetricReportService m_reportService;
    @Inject
    protected MetricConfigManager m_configManager;
    @Inject
    protected ProductLineConfigManager m_productLineConfigManager;
    @Inject
    protected BaselineCreator m_baselineCreator;
    @Inject
    protected BaselineConfigManager m_baselineConfigManager;
    @Inject
    protected BaselineService m_baselineService;
    @Inject
    protected MetricPointParser m_parser;
    protected Logger m_logger;
    private static final int POINT_NUMBER = 1440;

    protected void buildDailyReportInternal(Map<String, MetricReport> reports, String reportName, String metricId, Date reportPeriod) {
        MetricItemConfig metricConfig = (MetricItemConfig)this.m_configManager.getMetricConfig().getMetricItemConfigs().get(metricId);
        String metricDomain = metricConfig.getDomain();
        String productLine = this.m_productLineConfigManager.queryProductLineByDomain(metricDomain);
        for (MetricType type : MetricType.values()) {
            String key = metricId + ":" + type;
            BaselineConfig baselineConfig = this.m_baselineConfigManager.queryBaseLineConfig(key);
            List days = baselineConfig.getDays();
            List weights = baselineConfig.getWeights();
            Date targetDate = new Date(reportPeriod.getTime() + (long)baselineConfig.getTargetDate() * 86400000L);
            ArrayList<double[]> values = new ArrayList<double[]>();
            for (Integer day : days) {
                ArrayList<MetricItem> metricItems = new ArrayList<MetricItem>();
                Date currentDate = new Date(reportPeriod.getTime() + (long)day.intValue() * 86400000L);
                for (int i = 0; i < 24; ++i) {
                    MetricItem reportItem;
                    Date start = new Date(currentDate.getTime() + (long)i * 3600000L);
                    Date end = new Date(start.getTime() + 3600000L);
                    String metricReportKey = productLine + ":" + start.getTime();
                    MetricReport report = reports.get(metricReportKey);
                    if (report == null) {
                        report = (MetricReport)this.m_reportService.queryReport(productLine, start, end);
                        reports.put(metricReportKey, report);
                    }
                    if ((reportItem = report.findMetricItem(metricId)) == null) {
                        reportItem = new MetricItem(metricId);
                    }
                    metricItems.add(reportItem);
                }
                double[] oneDayValue = this.m_parser.buildDailyData(metricItems, type);
                values.add(oneDayValue);
            }
            double[] result = this.m_baselineCreator.createBaseLine(values, weights, 1440);
            Baseline baseline = new Baseline();
            baseline.setDataInDoubleArray(result);
            baseline.setIndexKey(key);
            baseline.setReportName(reportName);
            baseline.setReportPeriod(targetDate);
            this.m_baselineService.insertBaseline(baseline);
            Date tomorrow = new Date(reportPeriod.getTime() + 86400000L);
            boolean exist = this.m_baselineService.hasDailyBaseline(reportName, key, tomorrow);
            if (exist) continue;
            Baseline tomorrowBaseline = new Baseline();
            tomorrowBaseline.setDataInDoubleArray(result);
            tomorrowBaseline.setIndexKey(key);
            tomorrowBaseline.setReportName(reportName);
            tomorrowBaseline.setReportPeriod(tomorrow);
            this.m_baselineService.insertBaseline(tomorrowBaseline);
        }
    }

    public boolean buildDailyTask(String reportName, String domain, Date reportPeriod) {
        HashMap reports = new HashMap();
        for (String metricID : this.m_configManager.getMetricConfig().getMetricItemConfigs().keySet()) {
            try {
                this.buildDailyReportInternal(reports, reportName, metricID, reportPeriod);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return true;
    }

    public boolean buildHourlyTask(String reportName, String reportDomain, Date reportPeriod) {
        throw new RuntimeException("Metric base line report don't support hourly report!");
    }

    public boolean buildMonthlyTask(String reportName, String reportDomain, Date reportPeriod) {
        throw new RuntimeException("Metric base line report don't support monthly report!");
    }

    public boolean buildWeeklyTask(String reportName, String reportDomain, Date reportPeriod) {
        throw new RuntimeException("Metric base line report don't support weekly report!");
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }
}

