/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.monitor;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.config.ProductLineConfig;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultMetric;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.page.monitor.Action;
import com.dianping.cat.report.page.monitor.Context;
import com.dianping.cat.report.page.monitor.Handler;
import com.dianping.cat.report.page.monitor.HttpStatus;
import com.dianping.cat.report.page.monitor.Payload;
import java.io.IOException;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JsonBuilder m_builder;

    private void buildBatchMetric(String content) {
        if (content != null) {
            String[] lines;
            for (String line : lines = content.split("\n")) {
                if (!StringUtils.isNotEmpty((String)line)) continue;
                String[] tabs = line.split("\t");
                if (tabs.length == 6) {
                    try {
                        String group = tabs[0];
                        String domain = tabs[1];
                        String key = tabs[2];
                        String type = tabs[3];
                        long time = Long.parseLong(tabs[4]);
                        double value = Double.parseDouble(tabs[5]);
                        this.buildMetric(group, domain, key, type, time, value);
                    }
                    catch (Exception e) {
                        Cat.logError((String)("Unrecognized batch data: " + line), (Throwable)e);
                    }
                    continue;
                }
                Cat.logError((Throwable)new RuntimeException("Unrecognized batch data: " + line));
            }
        }
    }

    private Metric buildMetric(Payload payload, String type, double value) {
        String group = payload.getGroup();
        String domain = payload.getDomain();
        String key = payload.getKey();
        long time = payload.getTimestamp();
        if (time <= 0L) {
            time = System.currentTimeMillis();
        }
        return this.buildMetric(group, domain, key, type, time, value);
    }

    private Metric buildMetric(String group, String domain, String key, String type, long time, double value) {
        Metric metric = Cat.getProducer().newMetric(group, key);
        DefaultMetric defaultMetric = (DefaultMetric)metric;
        defaultMetric.setTimestamp(time);
        if (MetricType.SUM.name().equalsIgnoreCase(type)) {
            defaultMetric.setStatus("S,C");
            defaultMetric.addData(String.format("%s,%.2f", 1, value));
        } else if (MetricType.AVG.name().equalsIgnoreCase(type)) {
            defaultMetric.setStatus("T");
            defaultMetric.addData(String.format("%.2f", value));
        } else if (MetricType.COUNT.name().equalsIgnoreCase(type)) {
            defaultMetric.setStatus("C");
            defaultMetric.addData(String.valueOf(value));
        } else {
            throw new RuntimeException("Error type in metric api, type: " + type);
        }
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        Message message = tree.getMessage();
        if (message instanceof Transaction) {
            ((DefaultTransaction)message).setTimestamp(time);
        }
        if (this.isGenericMetric(group)) {
            tree.setDomain(domain);
        }
        metric.complete();
        return defaultMetric;
    }

    public HttpStatus checkPars(Payload payload) {
        StringBuilder sb = new StringBuilder();
        String domain = payload.getDomain();
        String group = payload.getGroup();
        String key = payload.getKey();
        Action action = payload.getAction();
        HttpStatus httpStatus = new HttpStatus();
        boolean error = false;
        if (!Action.BATCH_API.equals((Object)action)) {
            if (StringUtils.isEmpty((String)domain)) {
                sb.append("domain ");
                error = true;
            }
            if (StringUtils.isEmpty((String)group)) {
                sb.append("group ");
                error = true;
            }
            if (StringUtils.isEmpty((String)key)) {
                sb.append("key ");
                error = true;
            }
        }
        if (error) {
            httpStatus.setErrorMsg("invalid field: " + sb.toString());
            httpStatus.setStatusCode(String.valueOf(-1));
        } else {
            httpStatus.setStatusCode(String.valueOf(0));
        }
        return httpStatus;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="monitor")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="monitor")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        HttpStatus status = this.checkPars(payload);
        if (status.getStatusCode().equals(String.valueOf(0))) {
            switch (1.$SwitchMap$com$dianping$cat$report$page$monitor$Action[action.ordinal()]) {
                case 1: {
                    this.buildMetric(payload, MetricType.COUNT.name(), (double)payload.getCount());
                    break;
                }
                case 2: {
                    this.buildMetric(payload, MetricType.AVG.name(), payload.getAvg());
                    break;
                }
                case 3: {
                    this.buildMetric(payload, MetricType.SUM.name(), payload.getSum());
                    break;
                }
                case 4: {
                    this.buildBatchMetric(payload.getBatch());
                }
            }
        }
        ctx.getHttpServletResponse().getWriter().write(this.m_builder.toJson((Object)status));
    }

    private boolean isDatabase(String group) {
        return ProductLineConfig.DATABASE.isTypeOf(group);
    }

    private boolean isGenericMetric(String group) {
        return !this.isNetwork(group) && !this.isSystem(group) && !this.isDatabase(group);
    }

    private boolean isNetwork(String group) {
        return ProductLineConfig.NETWORK.isTypeOf(group);
    }

    private boolean isSystem(String group) {
        return ProductLineConfig.SYSTEM.isTypeOf(group);
    }
}

