/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.network;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.report.alert.AlertInfo;
import com.dianping.cat.report.alert.MetricType;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.metric.AbstractGraphCreator;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphCreator
extends AbstractGraphCreator {
    public Map<String, LineChart> buildChartData(String productLine, Map<String, double[]> datas, Date startDate, Date endDate, Map<String, double[]> dataWithOutFutures) {
        Map aggregationKeys = this.buildLineChartKeys(dataWithOutFutures.keySet());
        LinkedHashMap<String, LineChart> charts = new LinkedHashMap<String, LineChart>();
        List alertKeys = this.m_alertInfo.queryLastestAlarmKey(5);
        int step = this.m_dataExtractor.getStep();
        for (Map.Entry keyMapEntry : aggregationKeys.entrySet()) {
            String chartTitle = (String)keyMapEntry.getKey();
            LineChart lineChart = new LineChart();
            lineChart.setTitle(chartTitle);
            lineChart.setHtmlTitle(chartTitle);
            lineChart.setId(chartTitle);
            lineChart.setStart(startDate);
            lineChart.setStep((long)step * 60000L);
            lineChart.setUnit(this.buildUnit(chartTitle));
            for (String key : (List)keyMapEntry.getValue()) {
                if (dataWithOutFutures.containsKey(key)) {
                    Map all = this.convertToMap(datas.get(key), startDate, 1);
                    Map current = this.convertToMap(dataWithOutFutures.get(key), startDate, step);
                    this.buildLineChartTitle(productLine, lineChart, key, alertKeys);
                    this.addLastMinuteData(current, all, this.m_lastMinute, endDate);
                    this.convertFlowMetric(lineChart, current, this.buildLineTitle(key));
                    continue;
                }
                lineChart.add(chartTitle, this.buildNoneData(startDate, endDate, 1));
            }
            charts.put(chartTitle, lineChart);
        }
        return charts;
    }

    public Map<String, LineChart> buildChartsByProductLine(String productLine, Date startDate, Date endDate) {
        Map oldCurrentValues = this.prepareAllData(productLine, startDate, endDate);
        Map allCurrentValues = this.m_dataExtractor.extract(oldCurrentValues);
        Map dataWithOutFutures = this.removeFutureData(endDate, allCurrentValues);
        return this.buildChartData(productLine, oldCurrentValues, startDate, endDate, dataWithOutFutures);
    }

    private Set<String> buildKeysWithoutType(Set<String> keys) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String key : keys) {
            int index = key.lastIndexOf(":");
            String frontKey = key.substring(0, index);
            result.add(frontKey);
        }
        return result;
    }

    private Map<String, List<String>> buildLineChartKeys(Set<String> originKeys) {
        Object groupName;
        LinkedHashSet<String> groupSet = new LinkedHashSet<String>();
        LinkedHashMap<String, List<String>> aggregationKeys = new LinkedHashMap<String, List<String>>();
        Set keys = this.buildKeysWithoutType(originKeys);
        for (String key : keys) {
            try {
                int hyphenIndex = key.lastIndexOf("-");
                groupName = key.substring(0, hyphenIndex);
                groupSet.add((String)groupName);
            }
            catch (Exception exception) {
                Cat.logError((Throwable)new RuntimeException("network agent send metric [" + key + "]  error"));
            }
        }
        for (String group : groupSet) {
            ArrayList<String> keyList = new ArrayList<String>();
            for (String key : keys) {
                if (!key.startsWith(group)) continue;
                if (this.isSumTypeMetric(group)) {
                    keyList.add(key + ":" + MetricType.SUM);
                    continue;
                }
                keyList.add(key + ":" + MetricType.AVG);
            }
            groupName = group.substring(group.lastIndexOf(":") + 1);
            aggregationKeys.put((String)groupName, keyList);
        }
        return aggregationKeys;
    }

    private void buildLineChartTitle(String productLine, LineChart lineChart, String key, List<AlertInfo.AlertMetric> alertKeys) {
        String title = lineChart.getHtmlTitle();
        String realKey = key.substring(0, key.lastIndexOf(":"));
        if (this.containsAlert(productLine, realKey, alertKeys) && !title.startsWith("<span style='color:red'>")) {
            lineChart.setHtmlTitle("<span style='color:red'>" + title + "</span>");
        } else {
            lineChart.setHtmlTitle(title);
        }
    }

    private String buildLineTitle(String lineKey) {
        return lineKey.substring(lineKey.lastIndexOf("-") + 1, lineKey.lastIndexOf(":"));
    }

    private boolean containsAlert(String productLine, String key, List<AlertInfo.AlertMetric> metrics) {
        for (AlertInfo.AlertMetric metric : metrics) {
            if (!metric.getGroup().equals(productLine) || !metric.getMetricId().equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isSumTypeMetric(String group) {
        return this.isFlowMetric(group) || group.toLowerCase().endsWith("-discard/error");
    }

    private Map<String, double[]> prepareAllData(String productLine, Date startDate, Date endDate) {
        long start;
        long end = endDate.getTime();
        int totalSize = (int)((end - start) / 60000L);
        LinkedHashMap<String, double[]> oldCurrentValues = new LinkedHashMap<String, double[]>();
        int index = 0;
        for (start = startDate.getTime(); start < end; start += 3600000L) {
            Map currentValues = this.queryMetricValueByDate(productLine, start);
            this.mergeMap(oldCurrentValues, currentValues, totalSize, index);
            ++index;
        }
        return oldCurrentValues;
    }

    private Map<String, double[]> queryMetricValueByDate(String productLine, long start) {
        MetricReport metricReport = this.m_metricReportService.queryMetricReport(productLine, new Date(start));
        Map currentValues = this.m_pruductDataFetcher.buildGraphData(metricReport);
        double sum = 0.0;
        for (Map.Entry entry : currentValues.entrySet()) {
            double[] value = (double[])entry.getValue();
            int length = value.length;
            for (int i = 0; i < length; ++i) {
                sum += value[i];
            }
        }
        return currentValues;
    }
}

