/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.network;

import com.dianping.cat.consumer.company.model.entity.ProductLine;
import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.network.Action;
import com.dianping.cat.report.page.network.Context;
import com.dianping.cat.report.page.network.GraphCreator;
import com.dianping.cat.report.page.network.Handler;
import com.dianping.cat.report.page.network.JspViewer;
import com.dianping.cat.report.page.network.Model;
import com.dianping.cat.report.page.network.Payload;
import com.dianping.cat.report.page.network.nettopology.NetGraphManager;
import com.dianping.cat.report.service.ModelPeriod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private ProductLineConfigManager m_productLineConfigManager;
    @Inject
    private GraphCreator m_graphCreator;
    @Inject
    private NetGraphManager m_netGraphManager;

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="network")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="network")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.normalize(model, payload);
        long date = payload.getDate();
        int timeRange = payload.getTimeRange();
        Date start = new Date(date - (long)(timeRange - 1) * 3600000L);
        Date end = new Date(date + 3600000L);
        switch (1.$SwitchMap$com$dianping$cat$report$page$network$Action[payload.getAction().ordinal()]) {
            case 1: {
                Map charts = this.m_graphCreator.buildChartsByProductLine(payload.getProduct(), start, end);
                model.setLineCharts(new ArrayList(charts.values()));
                break;
            }
            case 2: {
                model.setNetGraphData(this.m_netGraphManager.getNetGraphData(model.getStartTime(), model.getMinute()));
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        Collection productLines = this.m_productLineConfigManager.queryNetworkProductLines().values();
        model.setProductLines(productLines);
        model.setPage((Page)ReportPage.NETWORK);
        if (StringUtils.isEmpty((String)payload.getProduct()) && StringUtils.isEmpty((String)payload.getGroup()) && !productLines.isEmpty()) {
            payload.setProduct(((ProductLine)productLines.iterator().next()).getId());
        }
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        if (payload.getAction().equals((Object)Action.NETTOPOLOGY)) {
            long current = System.currentTimeMillis() - 60000L;
            int curMinute = (int)((current - current % 60000L) % 3600000L / 60000L);
            long startTime = payload.getDate();
            int minute = payload.getMinute();
            if (minute == -1) {
                minute = curMinute;
                if (curMinute == 59) {
                    startTime -= 3600000L;
                }
            }
            int maxMinute = 59;
            if (startTime == ModelPeriod.CURRENT.getStartTime()) {
                maxMinute = curMinute;
            }
            Date start = new Date(startTime);
            Date end = new Date(startTime + 3600000L - 1L);
            ArrayList<Integer> minutes = new ArrayList<Integer>();
            for (int i = 0; i < 60; ++i) {
                minutes.add(i);
            }
            model.setMinutes(minutes);
            model.setMinute(minute);
            model.setMaxMinute(maxMinute);
            model.setStartTime(start);
            model.setEndTime(end);
            model.setIpAddress(payload.getIpAddress());
            model.setAction((org.unidal.web.mvc.Action)payload.getAction());
            model.setDisplayDomain(payload.getDomain());
        } else {
            int timeRange = payload.getTimeRange();
            Date startTime = new Date(payload.getDate() - (long)(timeRange - 1) * 3600000L);
            Date endTime = new Date(payload.getDate() + 3600000L - 1L);
            model.setStartTime(startTime);
            model.setEndTime(endTime);
        }
    }
}

