/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.network.nettopology;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.home.network.entity.Anchor;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.home.network.entity.Switch;
import com.dianping.cat.report.alert.AlertInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetGraphBuilder {
    private static final int ERROR = 3;

    public NetGraphSet buildGraphSet(NetGraph netGraphTemplate, Map<String, MetricReport> reports, List<AlertInfo.AlertMetric> alertKeys) {
        NetGraphSet netGraphSet = new NetGraphSet();
        for (int minute = 0; minute <= 59; ++minute) {
            NetGraph netGraph = this.copyBaseInfoFromTemplate(netGraphTemplate);
            for (NetTopology netTopology : netGraph.getNetTopologies()) {
                ArrayList alertSwitchs = new ArrayList();
                for (Connection connection : netTopology.getConnections()) {
                    try {
                        this.buildConnectionInfo(reports, alertKeys, minute, alertSwitchs, connection);
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                for (Switch sw : netTopology.getSwitchs()) {
                    if (!alertSwitchs.contains(sw.getName())) continue;
                    sw.setState(Integer.valueOf(3));
                }
            }
            netGraph.setMinute(Integer.valueOf(minute));
            netGraphSet.addNetGraph(netGraph);
        }
        return netGraphSet;
    }

    private void buildConnectionInfo(Map<String, MetricReport> reports, List<AlertInfo.AlertMetric> alertKeys, int minute, List<String> alertSwitchs, Connection connection) {
        double insum = 0.0;
        double outsum = 0.0;
        double inDiscardsSum = 0.0;
        double outDiscardsSum = 0.0;
        double inErrorsSum = 0.0;
        double outErrorsSum = 0.0;
        int inState = 0;
        int outState = 0;
        int inDiscardsState = 0;
        int outDiscardsState = 0;
        int inErrorsState = 0;
        int outErrorsState = 0;
        for (Interface inter : connection.getInterfaces()) {
            String group = inter.getGroup();
            MetricReport report = reports.get(group);
            String domain = inter.getDomain();
            String prefix = inter.getKey();
            this.updateInterface(inter, report, minute);
            if (this.containsAlert(alertKeys, group, domain, prefix, "-flow-in")) {
                inter.setInstate(Integer.valueOf(3));
                inState = 3;
            }
            if (this.containsAlert(alertKeys, group, domain, prefix, "-discard/error-indiscards")) {
                inter.setInDiscardsState(Integer.valueOf(3));
                inDiscardsState = 3;
            }
            if (this.containsAlert(alertKeys, group, domain, prefix, "-discard/error-inerrors")) {
                inter.setInErrorsState(Integer.valueOf(3));
                inErrorsState = 3;
            }
            if (this.containsAlert(alertKeys, group, domain, prefix, "-flow-out")) {
                inter.setOutstate(Integer.valueOf(3));
                outState = 3;
            }
            if (this.containsAlert(alertKeys, group, domain, prefix, "-discard/error-outdiscards")) {
                inter.setOutDiscardsState(Integer.valueOf(3));
                outDiscardsState = 3;
            }
            if (this.containsAlert(alertKeys, group, domain, prefix, "-discard/error-outerrors")) {
                inter.setOutErrorsState(Integer.valueOf(3));
                outErrorsState = 3;
            }
            if (this.containsAlert(alertKeys, group, domain, prefix, "-status-up/down")) {
                inter.setInstate(Integer.valueOf(3));
                inter.setOutstate(Integer.valueOf(3));
                inter.setInDiscardsState(Integer.valueOf(3));
                inter.setOutDiscardsState(Integer.valueOf(3));
                inter.setInErrorsState(Integer.valueOf(3));
                inter.setOutErrorsState(Integer.valueOf(3));
                inState = 3;
                outState = 3;
                inDiscardsState = 3;
                outDiscardsState = 3;
                inErrorsState = 3;
                outErrorsState = 3;
            }
            insum += inter.getIn().doubleValue();
            outsum += inter.getOut().doubleValue();
            inDiscardsSum += inter.getInDiscards().doubleValue();
            outDiscardsSum += inter.getOutDiscards().doubleValue();
            inErrorsSum += inter.getInErrors().doubleValue();
            outErrorsSum += inter.getOutErrors().doubleValue();
        }
        connection.setInsum(Double.valueOf(insum));
        connection.setOutsum(Double.valueOf(outsum));
        connection.setInDiscards(Double.valueOf(inDiscardsSum));
        connection.setOutDiscards(Double.valueOf(outDiscardsSum));
        connection.setInErrors(Double.valueOf(inErrorsSum));
        connection.setOutErrors(Double.valueOf(outErrorsSum));
        connection.setInstate(Integer.valueOf(inState));
        connection.setOutstate(Integer.valueOf(outState));
        connection.setInDiscardsState(Integer.valueOf(inDiscardsState));
        connection.setOutDiscardsState(Integer.valueOf(outDiscardsState));
        connection.setInErrorsState(Integer.valueOf(inErrorsState));
        connection.setOutErrorsState(Integer.valueOf(outErrorsState));
        if (inState == 3 || outState == 3 || inDiscardsState == 3 || outDiscardsState == 3 || inErrorsState == 3 || outErrorsState == 3) {
            alertSwitchs.add(connection.getFrom());
        }
    }

    private boolean containsAlert(List<AlertInfo.AlertMetric> alertKeys, String group, String domain, String prefix, String suffix) {
        String actualKey = domain + ":Metric:" + prefix + suffix;
        for (AlertInfo.AlertMetric metric : alertKeys) {
            if (!metric.getGroup().equals(group) || !metric.getMetricId().equals(actualKey)) continue;
            return true;
        }
        return false;
    }

    private NetGraph copyBaseInfoFromTemplate(NetGraph netGraph) {
        NetGraph to = new NetGraph();
        for (NetTopology netTopologyA : netGraph.getNetTopologies()) {
            NetTopology netTopologyB = new NetTopology();
            for (Anchor anchorA : netTopologyA.getAnchors()) {
                Anchor anchorB = new Anchor();
                anchorB.setName(anchorA.getName());
                anchorB.setX(anchorA.getX());
                anchorB.setY(anchorA.getY());
                netTopologyB.addAnchor(anchorB);
            }
            for (Switch switchA : netTopologyA.getSwitchs()) {
                Switch switchB = new Switch();
                switchB.setName(switchA.getName());
                switchB.setX(switchA.getX());
                switchB.setY(switchA.getY());
                switchB.setState(switchA.getState());
                netTopologyB.addSwitch(switchB);
            }
            for (Connection connectionA : netTopologyA.getConnections()) {
                Connection connectionB = new Connection();
                for (Interface interA : connectionA.getInterfaces()) {
                    Interface interB = new Interface();
                    interB.setDomain(interA.getDomain());
                    interB.setGroup(interA.getGroup());
                    interB.setKey(interA.getKey());
                    interB.setIn(interA.getIn());
                    interB.setOut(interA.getOut());
                    interB.setInstate(interA.getInstate());
                    interB.setOutstate(interA.getOutstate());
                    interB.setInstate(interA.getInstate());
                    interB.setOutstate(interA.getOutstate());
                    interB.setInDiscardsState(interA.getInDiscardsState());
                    interB.setOutDiscardsState(interA.getOutDiscardsState());
                    interB.setInErrorsState(interA.getInErrorsState());
                    interB.setOutErrorsState(interA.getOutErrorsState());
                    connectionB.addInterface(interB);
                }
                connectionB.setInsum(connectionA.getInsum());
                connectionB.setOutsum(connectionA.getOutsum());
                connectionB.setFrom(connectionA.getFrom());
                connectionB.setTo(connectionA.getTo());
                connectionB.setInstate(connectionA.getInstate());
                connectionB.setOutstate(connectionA.getOutstate());
                connectionB.setInDiscardsState(connectionA.getInDiscardsState());
                connectionB.setOutDiscardsState(connectionA.getOutDiscardsState());
                connectionB.setInErrorsState(connectionA.getInErrorsState());
                connectionB.setOutErrorsState(connectionA.getOutErrorsState());
                netTopologyB.addConnection(connectionB);
            }
            to.addNetTopology(netTopologyB);
        }
        return to;
    }

    private void updateInterface(Interface inter, MetricReport report, int minute) {
        String domain = inter.getDomain();
        String key = inter.getKey();
        try {
            MetricItem inItem = report.findOrCreateMetricItem(domain + ":Metric:" + key + "-flow-in");
            MetricItem outItem = report.findOrCreateMetricItem(domain + ":Metric:" + key + "-flow-out");
            MetricItem inDiscardsItem = report.findOrCreateMetricItem(domain + ":Metric:" + key + "-discard/error-indiscards");
            MetricItem outDiscardsItem = report.findOrCreateMetricItem(domain + ":Metric:" + key + "-discard/error-outdiscards");
            MetricItem inErrorsItem = report.findOrCreateMetricItem(domain + ":Metric:" + key + "-discard/error-inerrors");
            MetricItem outErrorsItem = report.findOrCreateMetricItem(domain + ":Metric:" + key + "-discard/error-outerrors");
            inter.setIn(Double.valueOf(inItem.findOrCreateSegment(Integer.valueOf(minute)).getSum() / 60.0 * 8.0));
            inter.setOut(Double.valueOf(outItem.findOrCreateSegment(Integer.valueOf(minute)).getSum() / 60.0 * 8.0));
            inter.setInDiscards(Double.valueOf(inDiscardsItem.findOrCreateSegment(Integer.valueOf(minute)).getSum() / 60.0));
            inter.setOutDiscards(Double.valueOf(outDiscardsItem.findOrCreateSegment(Integer.valueOf(minute)).getSum() / 60.0));
            inter.setInErrors(Double.valueOf(inErrorsItem.findOrCreateSegment(Integer.valueOf(minute)).getSum() / 60.0));
            inter.setOutErrors(Double.valueOf(outErrorsItem.findOrCreateSegment(Integer.valueOf(minute)).getSum() / 60.0));
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

