/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.network.nettopology;

import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.entity.NetTopology;
import com.dianping.cat.report.alert.AlertInfo;
import com.dianping.cat.report.page.network.config.NetGraphConfigManager;
import com.dianping.cat.report.page.network.nettopology.NetGraphBuilder;
import com.dianping.cat.report.page.network.nettopology.NetGraphManager;
import com.dianping.cat.report.page.network.service.NetTopologyReportService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetGraphManager
implements Initializable,
LogEnabled {
    @Inject(type=ModelService.class, value={"metric"})
    private ModelService<MetricReport> m_service;
    @Inject
    private ServerConfigManager m_serverConfigManager;
    @Inject
    private NetTopologyReportService m_reportService;
    @Inject
    private NetGraphBuilder m_netGraphBuilder;
    @Inject
    private AlertInfo m_alertInfo;
    @Inject
    private NetGraphConfigManager m_netGraphConfigManager;
    private NetGraphSet m_currentNetGraphSet;
    private NetGraphSet m_lastNetGraphSet;
    protected Logger m_logger;
    private static final long DURATION = 60000L;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public List<Pair<String, String>> getNetGraphData(Date start, int minute) {
        NetGraph netGraph;
        JsonBuilder jb = new JsonBuilder();
        ArrayList<Pair<String, String>> netGraphData = new ArrayList<Pair<String, String>>();
        long current = System.currentTimeMillis();
        long currentHours = current - current % 3600000L;
        long startTime = start.getTime();
        NetGraphSet netGraphSet = null;
        netGraphSet = startTime >= currentHours ? this.m_currentNetGraphSet : (startTime == currentHours - 3600000L ? this.m_lastNetGraphSet : (NetGraphSet)this.m_reportService.queryReport("cat", start, new Date(start.getTime() + 3600000L)));
        if (netGraphSet != null && (netGraph = netGraphSet.findNetGraph(Integer.valueOf(minute))) != null) {
            for (NetTopology netTopology : netGraph.getNetTopologies()) {
                String topoName = netTopology.getName();
                String data = jb.toJson((Object)netTopology);
                netGraphData.add((Pair<String, String>)new Pair((Object)topoName, (Object)data));
            }
        }
        return netGraphData;
    }

    public void initialize() throws InitializationException {
        if (this.m_serverConfigManager.isJobMachine()) {
            Threads.forGroup((String)"cat").start((Runnable)new NetGraphReloader(this, null));
        }
    }

    private Set<String> queryAllGroups(NetGraph netGraphTemplate) {
        HashSet<String> groups = new HashSet<String>();
        for (NetTopology netTopology : netGraphTemplate.getNetTopologies()) {
            for (Connection connection : netTopology.getConnections()) {
                for (Interface inter : connection.getInterfaces()) {
                    groups.add(inter.getGroup());
                }
            }
        }
        return groups;
    }

    private Map<String, MetricReport> queryMetricReports(Set<String> groups, ModelPeriod period) {
        HashMap<String, MetricReport> reports = new HashMap<String, MetricReport>();
        for (String group : groups) {
            ModelRequest request = new ModelRequest(group, period);
            ModelResponse response = this.m_service.invoke(request);
            MetricReport report = (MetricReport)response.getModel();
            reports.put(group, report);
        }
        return reports;
    }

    static /* synthetic */ NetGraphConfigManager access$100(NetGraphManager x0) {
        return x0.m_netGraphConfigManager;
    }

    static /* synthetic */ Set access$200(NetGraphManager x0, NetGraph x1) {
        return x0.queryAllGroups(x1);
    }

    static /* synthetic */ Map access$300(NetGraphManager x0, Set x1, ModelPeriod x2) {
        return x0.queryMetricReports(x1, x2);
    }

    static /* synthetic */ AlertInfo access$400(NetGraphManager x0) {
        return x0.m_alertInfo;
    }

    static /* synthetic */ NetGraphSet access$502(NetGraphManager x0, NetGraphSet x1) {
        x0.m_currentNetGraphSet = x1;
        return x0.m_currentNetGraphSet;
    }

    static /* synthetic */ NetGraphBuilder access$600(NetGraphManager x0) {
        return x0.m_netGraphBuilder;
    }

    static /* synthetic */ NetGraphSet access$702(NetGraphManager x0, NetGraphSet x1) {
        x0.m_lastNetGraphSet = x1;
        return x0.m_lastNetGraphSet;
    }
}

