/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.network.service;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.transform.DefaultNativeParser;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetTopologyReportService
extends AbstractReportService<NetGraphSet> {
    public NetGraphSet makeReport(String domain, Date start, Date end) {
        NetGraphSet report = new NetGraphSet();
        return report;
    }

    public NetGraphSet queryDailyReport(String domain, Date start, Date end) {
        throw new RuntimeException("net topology report don't support daily report");
    }

    private NetGraphSet queryFromHourlyBinary(int id) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, HourlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return null;
    }

    public NetGraphSet queryHourlyReport(String domain, Date start, Date end) {
        long startTime = start.getTime();
        String name = "NetTopology";
        NetGraphSet netGraphs = null;
        List reports = null;
        try {
            reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
        if (reports != null && reports.size() > 0) {
            try {
                netGraphs = this.queryFromHourlyBinary(((HourlyReport)reports.get(0)).getId());
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
        }
        return netGraphs;
    }

    public NetGraphSet queryMonthlyReport(String domain, Date start) {
        throw new RuntimeException("net topology report don't support monthly report");
    }

    public NetGraphSet queryWeeklyReport(String domain, Date start) {
        throw new RuntimeException("net topology report don't support weekly report");
    }
}

