/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.network.task;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.home.network.entity.Connection;
import com.dianping.cat.home.network.entity.Interface;
import com.dianping.cat.home.network.entity.NetGraph;
import com.dianping.cat.home.network.entity.NetGraphSet;
import com.dianping.cat.home.network.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.metric.service.MetricReportService;
import com.dianping.cat.report.page.network.config.NetGraphConfigManager;
import com.dianping.cat.report.page.network.nettopology.NetGraphBuilder;
import com.dianping.cat.report.page.network.service.NetTopologyReportService;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.unidal.lookup.annotation.Inject;

public class NetTopologyReportBuilder
implements TaskBuilder {
    public static final String ID = "NetTopology";
    @Inject
    protected NetTopologyReportService m_reportService;
    @Inject
    protected MetricReportService m_metricReportService;
    @Inject
    private NetGraphBuilder m_netGraphBuilder;
    @Inject
    private NetGraphConfigManager m_netGraphConfigManager;

    public boolean buildDailyTask(String name, String domain, Date period) {
        throw new UnsupportedOperationException("no daily report builder for net topology!");
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        NetGraph netGraphTemplate = (NetGraph)this.m_netGraphConfigManager.getConfig().getNetGraphs().get(0);
        HashSet<String> groups = new HashSet<String>();
        for (Object netTopology : netGraphTemplate.getNetTopologies()) {
            for (Connection connection : netTopology.getConnections()) {
                for (Interface inter : connection.getInterfaces()) {
                    groups.add(inter.getGroup());
                }
            }
        }
        HashMap<String, MetricReport> reports = new HashMap<String, MetricReport>();
        for (String group : groups) {
            Date end = new Date(period.getTime() + 3600000L);
            MetricReport report = (MetricReport)this.m_metricReportService.queryReport(group, period, end);
            reports.put(group, report);
        }
        NetGraphSet netGraphSet = this.m_netGraphBuilder.buildGraphSet(netGraphTemplate, reports, new ArrayList());
        HourlyReport hourlyReport = new HourlyReport();
        hourlyReport.setType(1);
        hourlyReport.setName(name);
        hourlyReport.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        hourlyReport.setDomain(domain);
        hourlyReport.setPeriod(period);
        byte[] content = DefaultNativeBuilder.build((NetGraphSet)netGraphSet);
        return this.m_reportService.insertHourlyReport(hourlyReport, content);
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new UnsupportedOperationException("no monthly report builder for net topology!");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new UnsupportedOperationException("no weekly report builder for net topology!");
    }
}

