/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.overload.task;

import com.dianping.cat.Cat;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.dal.report.OverloadDao;
import com.dianping.cat.home.dal.report.OverloadEntity;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

public class CapacityUpdateStatusManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private OverloadDao m_overloadDao;
    private static final String CONFIG_NAME = "capacityUpdateStatus";
    private int m_hourlyStatus;
    private int m_dailyStatus;
    private int m_weeklyStatus;
    private int m_monthlyStatus;
    private int m_configId;

    private String buildConfigContent() {
        StringBuilder builder = new StringBuilder();
        builder.append("Hourly:").append(this.m_hourlyStatus).append(";");
        builder.append("Daily:").append(this.m_dailyStatus).append(";");
        builder.append("Weekly:").append(this.m_weeklyStatus).append(";");
        builder.append("Monthly:").append(this.m_monthlyStatus).append(";");
        return builder.toString();
    }

    private void extractStatus(String content) {
        this.m_hourlyStatus = Integer.parseInt(content.split("Hourly:")[1].split(";")[0]);
        this.m_dailyStatus = Integer.parseInt(content.split("Daily:")[1].split(";")[0]);
        this.m_weeklyStatus = Integer.parseInt(content.split("Weekly:")[1].split(";")[0]);
        this.m_monthlyStatus = Integer.parseInt(content.split("Monthly:")[1].split(";")[0]);
    }

    public int getDailyStatus() {
        return this.m_dailyStatus;
    }

    public int getHourlyStatus() {
        return this.m_hourlyStatus;
    }

    public int getMonthlyStatus() {
        return this.m_monthlyStatus;
    }

    public int getWeeklyStatus() {
        return this.m_weeklyStatus;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.extractStatus(content);
        }
        catch (DalException e) {
            try {
                this.m_hourlyStatus = this.m_overloadDao.findMaxIdByType(1, OverloadEntity.READSET_MAXID).getMaxId();
                this.m_dailyStatus = this.m_overloadDao.findMaxIdByType(2, OverloadEntity.READSET_MAXID).getMaxId();
                this.m_weeklyStatus = this.m_overloadDao.findMaxIdByType(3, OverloadEntity.READSET_MAXID).getMaxId();
                this.m_monthlyStatus = this.m_overloadDao.findMaxIdByType(4, OverloadEntity.READSET_MAXID).getMaxId();
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(this.buildConfigContent());
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
            }
            catch (DalException ex) {
                Cat.logError((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        CapacityUpdateStatusManager capacityUpdateStatusManager = this;
        synchronized (capacityUpdateStatusManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.buildConfigContent());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void updateDailyStatus(int dailyStatus) {
        this.m_dailyStatus = dailyStatus;
        this.storeConfig();
    }

    public void updateHourlyStatus(int hourlyStatus) {
        this.m_hourlyStatus = hourlyStatus;
        this.storeConfig();
    }

    public void updateMonthlyStatus(int monthlyStatus) {
        this.m_monthlyStatus = monthlyStatus;
        this.storeConfig();
    }

    public void updateWeeklyStatus(int weeklyStatus) {
        this.m_weeklyStatus = weeklyStatus;
        this.storeConfig();
    }
}

