/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.overload.task;

import com.dianping.cat.Cat;
import com.dianping.cat.report.page.overload.task.CapacityUpdater;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.Date;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

public class CapacityUpdateTask
implements TaskBuilder,
LogEnabled {
    public static final String ID = "databaseCapacity";
    @Inject(type=CapacityUpdater.class, value={"hourly_capacity_updater"})
    private CapacityUpdater m_hourlyUpdater;
    @Inject(type=CapacityUpdater.class, value={"daily_capacity_updater"})
    private CapacityUpdater m_dailyUpdater;
    @Inject(type=CapacityUpdater.class, value={"weekly_capacity_updater"})
    private CapacityUpdater m_weeklyUpdater;
    @Inject(type=CapacityUpdater.class, value={"monthly_capacity_updater"})
    private CapacityUpdater m_monthlyUpdater;
    protected Logger m_logger;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            this.m_dailyUpdater.updateDBCapacity();
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        try {
            this.m_hourlyUpdater.updateDBCapacity();
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        try {
            this.m_monthlyUpdater.updateDBCapacity();
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        try {
            this.m_weeklyUpdater.updateDBCapacity();
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void setDailyUpdater(CapacityUpdater dailyUpdater) {
        this.m_dailyUpdater = dailyUpdater;
    }

    public void setHourlyUpdater(CapacityUpdater hourlyUpdater) {
        this.m_hourlyUpdater = hourlyUpdater;
    }

    public void setMonthlyUpdater(CapacityUpdater monthlyUpdater) {
        this.m_monthlyUpdater = monthlyUpdater;
    }

    public void setWeeklyUpdater(CapacityUpdater weeklyUpdater) {
        this.m_weeklyUpdater = weeklyUpdater;
    }
}

