/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.overload.task;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentDao;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.home.dal.report.Overload;
import com.dianping.cat.home.dal.report.OverloadDao;
import com.dianping.cat.report.page.overload.task.CapacityUpdateStatusManager;
import com.dianping.cat.report.page.overload.task.CapacityUpdater;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

public class DailyCapacityUpdater
implements CapacityUpdater {
    @Inject
    private DailyReportContentDao m_dailyReportContentDao;
    @Inject
    private DailyReportDao m_dailyReportDao;
    @Inject
    private OverloadDao m_overloadDao;
    @Inject
    private CapacityUpdateStatusManager m_manager;
    public static final String ID = "daily_capacity_updater";

    public String getId() {
        return ID;
    }

    public void updateDBCapacity() throws DalException {
        int maxId = this.m_manager.getDailyStatus();
        while (true) {
            List reports = this.m_dailyReportContentDao.findOverloadReport(maxId, DailyReportContentEntity.READSET_LENGTH);
            for (DailyReportContent content : reports) {
                try {
                    int reportId = content.getReportId();
                    double contentLength = content.getContentLength();
                    if (!(contentLength >= 15.0)) continue;
                    Overload overload = this.m_overloadDao.createLocal();
                    overload.setReportId(reportId);
                    overload.setReportSize(contentLength);
                    overload.setReportType(2);
                    try {
                        DailyReport report = this.m_dailyReportDao.findByPK(reportId, DailyReportEntity.READSET_FULL);
                        overload.setPeriod(report.getPeriod());
                        this.m_overloadDao.insert(overload);
                    }
                    catch (DalNotFoundException report) {
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                catch (Exception ex) {
                    Cat.logError((Throwable)ex);
                }
            }
            int size = reports.size();
            if (size == 0) break;
            maxId = ((DailyReportContent)reports.get(size - 1)).getReportId();
        }
        this.m_manager.updateDailyStatus(maxId);
    }
}

