/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.overload.task;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportDao;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportDao;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportDao;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.home.dal.report.Overload;
import com.dianping.cat.home.dal.report.OverloadDao;
import com.dianping.cat.home.dal.report.OverloadEntity;
import com.dianping.cat.report.page.overload.task.OverloadReport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCapacityService
extends ContainerHolder {
    @Inject
    private OverloadDao m_overloadDao;
    @Inject
    private HourlyReportDao m_hourlyReportDao;
    @Inject
    private DailyReportDao m_dailyReportDao;
    @Inject
    private WeeklyReportDao m_weeklyReportDao;
    @Inject
    private MonthlyReportDao m_monthlyReportDao;

    private OverloadReport generateOverloadReport(Object object, double reportSize, int reportType) {
        OverloadReport overloadReport = new OverloadReport();
        switch (reportType) {
            case 1: {
                overloadReport.setDomain(((HourlyReport)object).getDomain());
                overloadReport.setIp(((HourlyReport)object).getIp());
                overloadReport.setName(((HourlyReport)object).getName());
                overloadReport.setPeriod(((HourlyReport)object).getPeriod());
                overloadReport.setType(((HourlyReport)object).getType());
                break;
            }
            case 2: {
                overloadReport.setDomain(((DailyReport)object).getDomain());
                overloadReport.setIp(((DailyReport)object).getIp());
                overloadReport.setName(((DailyReport)object).getName());
                overloadReport.setPeriod(((DailyReport)object).getPeriod());
                overloadReport.setType(((DailyReport)object).getType());
                break;
            }
            case 3: {
                overloadReport.setDomain(((WeeklyReport)object).getDomain());
                overloadReport.setIp(((WeeklyReport)object).getIp());
                overloadReport.setName(((WeeklyReport)object).getName());
                overloadReport.setPeriod(((WeeklyReport)object).getPeriod());
                overloadReport.setType(((WeeklyReport)object).getType());
                break;
            }
            case 4: {
                overloadReport.setDomain(((MonthlyReport)object).getDomain());
                overloadReport.setIp(((MonthlyReport)object).getIp());
                overloadReport.setName(((MonthlyReport)object).getName());
                overloadReport.setPeriod(((MonthlyReport)object).getPeriod());
                overloadReport.setType(((MonthlyReport)object).getType());
            }
        }
        overloadReport.setReportType(reportType);
        overloadReport.setReportLength(reportSize);
        return overloadReport;
    }

    public List<OverloadReport> queryOverloadReports(Date startTime, Date endTime) {
        ArrayList<OverloadReport> reports = new ArrayList<OverloadReport>();
        try {
            List overloads = this.m_overloadDao.findIdAndSizeByDuration(startTime, endTime, OverloadEntity.READSET_ID_SIZE_TYPE);
            for (Overload overload : overloads) {
                try {
                    int reportId = overload.getReportId();
                    int reportType = overload.getReportType();
                    double reportSize = overload.getReportSize();
                    HourlyReport report = null;
                    switch (reportType) {
                        case 1: {
                            report = this.m_hourlyReportDao.findByPK(reportId, HourlyReportEntity.READSET_FULL);
                            break;
                        }
                        case 2: {
                            report = this.m_dailyReportDao.findByPK(reportId, DailyReportEntity.READSET_FULL);
                            break;
                        }
                        case 3: {
                            report = this.m_weeklyReportDao.findByPK(reportId, WeeklyReportEntity.READSET_FULL);
                            break;
                        }
                        case 4: {
                            report = this.m_monthlyReportDao.findByPK(reportId, MonthlyReportEntity.READSET_FULL);
                        }
                    }
                    reports.add(this.generateOverloadReport((Object)report, reportSize, reportType));
                }
                catch (DalNotFoundException reportId) {
                }
                catch (Exception ex) {
                    Cat.logError((Throwable)ex);
                }
            }
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
        return reports;
    }
}

