/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem;

import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.JavaThread;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.report.page.problem.GroupLevelInfo;
import com.dianping.cat.report.page.problem.Model;
import com.dianping.cat.report.view.ProblemReportHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupLevelInfo {
    private List<String> m_datas = new ArrayList();
    private Map<String, GroupStatistics> m_groupStatistics = new LinkedHashMap();
    private int m_minutes;
    private Model m_model;

    public GroupLevelInfo(Model model) {
        this.m_model = model;
        this.m_minutes = model.getLastMinute();
    }

    public GroupLevelInfo display(ProblemReport report) {
        Machine machine = (Machine)report.getMachines().get(this.m_model.getIpAddress());
        if (machine == null) {
            return null;
        }
        Collection entities = machine.getEntities().values();
        for (Entity entity : entities) {
            Map threads = entity.getThreads();
            for (Map.Entry entry : threads.entrySet()) {
                JavaThread thread = (JavaThread)entry.getValue();
                String groupName = thread.getGroupName();
                GroupStatistics statistics = this.findOrCreatGroupStatistics(groupName, this.m_minutes);
                statistics.add(thread.getSegments(), entity.getType());
            }
        }
        long currentTimeMillis = System.currentTimeMillis();
        long currentHours = currentTimeMillis - currentTimeMillis % 3600000L;
        if (currentHours == this.m_model.getLongDate()) {
            for (int i = this.m_minutes; i >= 0; --i) {
                this.m_datas.add(this.getShowDetailByMinte(i));
            }
        } else {
            for (int i = 0; i <= this.m_minutes; ++i) {
                this.m_datas.add(this.getShowDetailByMinte(i));
            }
        }
        return this;
    }

    public GroupStatistics findOrCreatGroupStatistics(String groupName, int lastMinute) {
        this.m_minutes = lastMinute;
        GroupStatistics value = (GroupStatistics)this.m_groupStatistics.get(groupName);
        if (value == null) {
            GroupStatistics result = new GroupStatistics(lastMinute);
            this.m_groupStatistics.put(groupName, result);
            return result;
        }
        return value;
    }

    public List<String> getDatas() {
        return this.m_datas;
    }

    public List<String> getGroups() {
        return SortHelper.sortDomain(this.m_groupStatistics.keySet());
    }

    private String getShowDetailByMinte(int minute) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        String baseUrl = "/cat/r/p?op=detail";
        params.put("domain", this.m_model.getDomain());
        params.put("ip", this.m_model.getIpAddress());
        params.put("date", this.m_model.getDate());
        params.put("minute", Integer.toString(minute));
        StringBuilder sb = new StringBuilder().append("<td>");
        String minuteStr = this.m_model.getDisplayHour() + ":";
        minuteStr = minute < 10 ? minuteStr + "0" + Integer.toString(minute) : minuteStr + Integer.toString(minute);
        sb.append(ProblemReportHelper.creatLinkString((String)baseUrl, (String)"minute", params, (String)minuteStr));
        sb.append("</td>");
        for (String group : this.getGroups()) {
            sb.append("<td>");
            params.put("group", group);
            GroupStatistics value = (GroupStatistics)this.m_groupStatistics.get(group);
            for (String temp : (TreeSet)value.getStatistics().get(minute)) {
                String url = ProblemReportHelper.creatLinkString((String)baseUrl, (String)temp, params, (String)"");
                sb.append(url);
            }
            sb.append("</td>");
        }
        return sb.toString();
    }
}

