/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyGraph;
import com.dianping.cat.core.dal.DailyGraphDao;
import com.dianping.cat.core.dal.DailyGraphEntity;
import com.dianping.cat.core.dal.Graph;
import com.dianping.cat.core.dal.GraphDao;
import com.dianping.cat.core.dal.GraphEntity;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.BaseHistoryGraphs;
import com.dianping.cat.report.page.problem.Handler;
import com.dianping.cat.report.page.problem.Model;
import com.dianping.cat.report.page.problem.Payload;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryGraphs
extends BaseHistoryGraphs {
    private static final String ERROR = "errors";
    @Inject
    private GraphDao m_graphDao;
    @Inject
    private DailyGraphDao m_dailyGraphDao;

    private LineChart buildFail(List<Map<String, double[]>> datas, Date start, long step, int size, String queryType) {
        LineChart item = new LineChart();
        item.setStart(start);
        item.setSize(size);
        item.setStep(step);
        for (Map<String, double[]> data : datas) {
            item.addValue(data.get(ERROR));
        }
        item.setSubTitles(this.buildSubTitle(start, size, step, queryType));
        return item;
    }

    public Map<String, double[]> buildGraphDatasForDaily(Date start, Date end, String type, String name, List<DailyGraph> graphs) {
        HashMap<String, double[]> result = new HashMap<String, double[]>();
        int size = (int)((end.getTime() - start.getTime()) / 86400000L);
        double[] errorCount = new double[size];
        if (!StringUtils.isEmpty((String)type) && StringUtils.isEmpty((String)name)) {
            for (DailyGraph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) / 86400000L);
                String summaryContent = graph.getSummaryContent();
                String[] allLines = summaryContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String[] records = allLines[j].split("\t");
                    if (!records[Handler.SummaryOrder.TYPE.ordinal()].equals(type)) continue;
                    errorCount[indexOfperiod] = Double.valueOf(records[Handler.SummaryOrder.TOTAL_COUNT.ordinal()]);
                }
            }
        } else if (!StringUtils.isEmpty((String)type) && !StringUtils.isEmpty((String)name)) {
            for (DailyGraph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) / 86400000L);
                String detailContent = graph.getDetailContent();
                String[] allLines = detailContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String[] records = allLines[j].split("\t");
                    if (!records[Handler.DetailOrder.TYPE.ordinal()].equals(type) || !records[Handler.DetailOrder.STATUS.ordinal()].equals(name)) continue;
                    errorCount[indexOfperiod] = Double.valueOf(records[Handler.DetailOrder.TOTAL_COUNT.ordinal()]);
                }
            }
        }
        result.put(ERROR, errorCount);
        return result;
    }

    public Map<String, double[]> buildGraphDatasFromHour(Date start, Date end, String type, String status, List<Graph> graphs) {
        HashMap<String, double[]> result = new HashMap<String, double[]>();
        int size = (int)((end.getTime() - start.getTime()) / 3600000L) * 60;
        double[] errors = new double[size];
        if (!StringUtils.isEmpty((String)type) && StringUtils.isEmpty((String)status)) {
            for (Graph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) / 3600000L * 60L);
                String summaryContent = graph.getSummaryContent();
                String[] allLines = summaryContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String dbType;
                    String[] records = allLines[j].split("\t");
                    if (records.length < Handler.SummaryOrder.values().length || !(dbType = records[Handler.SummaryOrder.TYPE.ordinal()]).equals(type)) continue;
                    String[] values = records[Handler.SummaryOrder.DETAIL.ordinal()].split(",");
                    for (int k = 0; k < values.length; ++k) {
                        errors[indexOfperiod + k] = Double.parseDouble(values[k]);
                    }
                }
            }
        } else if (!StringUtils.isEmpty((String)type) && !StringUtils.isEmpty((String)status)) {
            for (Graph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) / 3600000L * 60L);
                String detailContent = graph.getDetailContent();
                String[] allLines = detailContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String[] records = allLines[j].split("\t");
                    if (records.length < Handler.DetailOrder.values().length) continue;
                    String dbStatus = records[Handler.DetailOrder.STATUS.ordinal()];
                    String dbType = records[Handler.DetailOrder.TYPE.ordinal()];
                    if (!status.equals(dbStatus) || !type.equals(dbType)) continue;
                    String[] values = records[Handler.DetailOrder.DETAIL.ordinal()].split(",");
                    for (int k = 0; k < values.length; ++k) {
                        errors[indexOfperiod + k] = Double.parseDouble(values[k]);
                    }
                }
            }
        }
        result.put(ERROR, errors);
        return result;
    }

    public void buildGroupTrendGraph(Model model, Payload payload, List<String> ips) {
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        String domain = model.getDomain();
        String type = payload.getType();
        String name = payload.getStatus();
        int size = (int)((end.getTime() - start.getTime()) * 12L / 3600000L);
        long step = 300000L;
        String queryType = payload.getReportType();
        if (queryType.equalsIgnoreCase("month")) {
            size = (int)((end.getTime() - start.getTime()) / 86400000L);
            step = 86400000L;
        }
        List allDatas = null;
        for (String ip : ips) {
            List datas = this.buildLineChartData(start, end, domain, type, name, ip, queryType);
            if (allDatas == null) {
                allDatas = datas;
                continue;
            }
            this.mergerList(allDatas, datas);
        }
        LineChart item = this.buildFail(allDatas, start, step, size, queryType);
        model.setErrorsTrend(item.getJsonString());
    }

    private List<Map<String, double[]>> buildLineChartData(Date start, Date end, String domain, String type, String name, String ip, String queryType) {
        ArrayList<Map<String, double[]>> allDatas = new ArrayList<Map<String, double[]>>();
        if (queryType.equalsIgnoreCase("day")) {
            Map currentGraph = this.getGraphDatasFromHour(start, end, domain, type, name, ip);
            Map lastDayGraph = this.getGraphDatasFromHour(new Date(start.getTime() - 86400000L), new Date(end.getTime() - 86400000L), domain, type, name, ip);
            Map lastWeekGraph = this.getGraphDatasFromHour(new Date(start.getTime() - 604800000L), new Date(end.getTime() - 604800000L), domain, type, name, ip);
            allDatas.add(currentGraph);
            allDatas.add(lastDayGraph);
            allDatas.add(lastWeekGraph);
        } else if (queryType.equalsIgnoreCase("week")) {
            Map currentGraph = this.getGraphDatasFromDaily(start, end, domain, type, name, ip);
            Map lastWeek = this.getGraphDatasFromDaily(new Date(start.getTime() - 604800000L), new Date(end.getTime() - 604800000L), domain, type, name, ip);
            allDatas.add(currentGraph);
            allDatas.add(lastWeek);
        } else if (queryType.equalsIgnoreCase("month")) {
            Map graphData = this.getGraphDatasFromDaily(start, end, domain, type, name, ip);
            allDatas.add(graphData);
        } else {
            throw new RuntimeException("Error graph query type");
        }
        return allDatas;
    }

    public void buildTrendGraph(Model model, Payload payload) {
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        int size = (int)((end.getTime() - start.getTime()) * 60L / 3600000L);
        String queryType = payload.getReportType();
        String domain = model.getDomain();
        String type = payload.getType();
        String name = payload.getStatus();
        String ip = model.getIpAddress();
        long step = 60000L;
        if (queryType.equalsIgnoreCase("week")) {
            size = (int)((end.getTime() - start.getTime()) / 86400000L);
            step = 86400000L;
        } else if (queryType.equalsIgnoreCase("month")) {
            size = (int)((end.getTime() - start.getTime()) / 86400000L);
            step = 86400000L;
        }
        List allDatas = this.buildLineChartData(start, end, domain, type, name, ip, queryType);
        LineChart item = this.buildFail(allDatas, start, step, size, queryType);
        model.setErrorsTrend(item.getJsonString());
    }

    private Map<String, double[]> getGraphDatasFromDaily(Date start, Date end, String domain, String type, String name, String ip) {
        String queryIp = "All".equalsIgnoreCase(ip) ? "All" : ip;
        ArrayList<DailyGraph> graphs = new ArrayList<DailyGraph>();
        for (long startLong = start.getTime(); startLong < end.getTime(); startLong += 86400000L) {
            try {
                DailyGraph graph = this.m_dailyGraphDao.findByDomainNameIpDate(new Date(startLong), queryIp, domain, "problem", DailyGraphEntity.READSET_FULL);
                graphs.add(graph);
                continue;
            }
            catch (DalNotFoundException graph) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return this.buildGraphDatasForDaily(start, end, type, name, graphs);
    }

    public Map<String, double[]> getGraphDatasFromHour(Date start, Date end, String domain, String type, String name, String ip) {
        String queryIP = "All".equals(ip) ? "all" : ip;
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (long startLong = start.getTime(); startLong < end.getTime(); startLong += 3600000L) {
            try {
                Graph graph = this.m_graphDao.findSingalByDomainNameIpDuration(new Date(startLong), queryIP, domain, "problem", GraphEntity.READSET_FULL);
                graphs.add(graph);
                continue;
            }
            catch (DalNotFoundException graph) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return this.buildGraphDatasFromHour(start, end, type, name, graphs);
    }
}

