/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem;

import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.JavaThread;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.report.page.problem.Model;
import com.dianping.cat.report.page.problem.ThreadLevelInfo;
import com.dianping.cat.report.view.ProblemReportHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLevelInfo {
    private List<String> m_datas = new ArrayList();
    private String m_groupName;
    private Map<String, GroupStatistics> m_groupStatistics = new LinkedHashMap();
    private int m_minutes;
    private Model m_model;
    private Map<String, TreeSet<String>> m_threadsInfo = new HashMap();

    public ThreadLevelInfo(Model model, String groupName) {
        this.m_groupName = groupName;
        this.m_model = model;
        this.m_minutes = model.getLastMinute();
    }

    public ThreadLevelInfo display(ProblemReport report) {
        Machine machine = (Machine)report.getMachines().get(this.m_model.getIpAddress());
        if (machine == null) {
            return null;
        }
        Collection entities = machine.getEntities().values();
        for (Entity temp : entities) {
            Map threads = temp.getThreads();
            for (Map.Entry entry : threads.entrySet()) {
                JavaThread thread = (JavaThread)entry.getValue();
                String groupName = thread.getGroupName();
                String threadId = thread.getId();
                GroupStatistics statistics = this.findOrCreatGroupStatistics(groupName, this.m_minutes);
                if (groupName.equals(this.m_groupName)) {
                    statistics.add(threadId, thread.getSegments(), this.m_minutes, temp.getType());
                    this.findOrCreatThreadInfo(groupName, threadId);
                    continue;
                }
                statistics.add(groupName, thread.getSegments(), this.m_minutes, temp.getType());
                this.findOrCreatThreadInfo(groupName, groupName);
            }
        }
        long currentTimeMillis = System.currentTimeMillis();
        long currentHours = currentTimeMillis - currentTimeMillis % 3600000L;
        if (currentHours == this.m_model.getLongDate()) {
            for (int i = this.m_minutes; i >= 0; --i) {
                this.m_datas.add(this.getShowDetailByMinte(i));
            }
        } else {
            for (int i = 0; i <= this.m_minutes; ++i) {
                this.m_datas.add(this.getShowDetailByMinte(i));
            }
        }
        return this;
    }

    public GroupStatistics findOrCreatGroupStatistics(String groupName, int lastMinute) {
        this.m_minutes = lastMinute;
        GroupStatistics value = (GroupStatistics)this.m_groupStatistics.get(groupName);
        if (value == null) {
            GroupStatistics result = new GroupStatistics();
            this.m_groupStatistics.put(groupName, result);
            return result;
        }
        return value;
    }

    private void findOrCreatThreadInfo(String groupName, String threadName) {
        TreeSet<String> sets = (TreeSet<String>)this.m_threadsInfo.get(groupName);
        if (sets != null) {
            sets.add(threadName);
        } else {
            sets = new TreeSet<String>();
            sets.add(threadName);
            this.m_threadsInfo.put(groupName, sets);
        }
    }

    public List<String> getDatas() {
        return this.m_datas;
    }

    public List<GroupDisplayInfo> getGroups() {
        ArrayList<GroupDisplayInfo> result = new ArrayList<GroupDisplayInfo>();
        for (Map.Entry entry : this.m_threadsInfo.entrySet()) {
            result.add(new GroupDisplayInfo().setName((String)entry.getKey()).setNumber(((TreeSet)entry.getValue()).size()));
        }
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private String getShowDetailByMinte(int minute) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        String baseUrl = "/cat/r/p?op=detail";
        params.put("domain", this.m_model.getDomain());
        params.put("ip", this.m_model.getIpAddress());
        params.put("date", this.m_model.getDate());
        params.put("minute", Integer.toString(minute));
        StringBuilder sb = new StringBuilder().append("<td>");
        String minuteStr = this.m_model.getDisplayHour() + ":";
        minuteStr = minute < 10 ? minuteStr + "0" + Integer.toString(minute) : minuteStr + Integer.toString(minute);
        sb.append(ProblemReportHelper.creatLinkString((String)baseUrl, (String)"minute", params, (String)minuteStr));
        sb.append("</td>");
        for (GroupDisplayInfo group : this.getGroups()) {
            String groupName = group.getName();
            GroupStatistics value = (GroupStatistics)this.m_groupStatistics.get(groupName);
            TreeSet threads = this.getThreadsByGroup(groupName);
            Map temps = value.getStatistics();
            for (String thread : threads) {
                TheadStatistics theadStatistics = (TheadStatistics)temps.get(thread);
                TreeSet errors = (TreeSet)theadStatistics.getStatistics().get(minute);
                sb.append("<td>");
                for (String error : errors) {
                    params.put("group", groupName);
                    if (groupName.equals(this.m_groupName)) {
                        params.put("thread", thread);
                    }
                    String url = ProblemReportHelper.creatLinkString((String)baseUrl, (String)error, params, (String)"");
                    sb.append(url);
                }
                sb.append("</td>");
            }
        }
        return sb.toString();
    }

    public List<String> getThreads() {
        ArrayList<String> result = new ArrayList<String>();
        for (TreeSet set : this.m_threadsInfo.values()) {
            for (String thread : set) {
                result.add(thread);
            }
        }
        return result;
    }

    private TreeSet<String> getThreadsByGroup(String groupName) {
        return (TreeSet)this.m_threadsInfo.get(groupName);
    }
}

