/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.task;

import com.dianping.cat.consumer.problem.model.entity.Duration;
import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.core.dal.DailyGraph;
import com.dianping.cat.report.page.problem.task.ProblemDailyGraphCreator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemDailyGraphCreator
extends BaseVisitor {
    private String m_currentIp;
    private String m_currentType;
    private String m_currentName;
    private MachineInfo m_allMachine = new MachineInfo("All");
    private Map<String, MachineInfo> m_machines = new HashMap();
    private List<DailyGraph> m_dailyGraphs = new ArrayList();

    public List<DailyGraph> buildDailyGraph() {
        return this.m_dailyGraphs;
    }

    private DailyGraph buildDailyGraph(ProblemReport problemReport, MachineInfo info) {
        DailyGraph graph = new DailyGraph();
        StringBuilder summary = new StringBuilder();
        StringBuilder detail = new StringBuilder();
        graph.setDomain(problemReport.getDomain());
        graph.setPeriod(problemReport.getStartTime());
        graph.setName("problem");
        graph.setIp(info.getIp());
        graph.setType(3);
        graph.setCreationDate(new Date());
        for (Map.Entry type : info.getTypesCount().entrySet()) {
            summary.append((String)type.getKey() + '\t' + type.getValue() + '\n');
        }
        for (Map.Entry name : info.getNameCount().entrySet()) {
            detail.append((String)name.getKey() + '\t' + name.getValue() + '\n');
        }
        graph.setSummaryContent(summary.toString());
        graph.setDetailContent(detail.toString());
        return graph;
    }

    private void buildMachineDetail(int count, MachineInfo info) {
        Integer type = (Integer)info.getTypesCount().get(this.m_currentType);
        Integer name = (Integer)info.getNameCount().get(this.m_currentType + "\t" + this.m_currentName);
        type = type == null ? Integer.valueOf(count) : Integer.valueOf(type + count);
        info.getTypesCount().put(this.m_currentType, type);
        name = name == null ? Integer.valueOf(count) : Integer.valueOf(name + count);
        info.getNameCount().put(this.m_currentType + "\t" + this.m_currentName, name);
    }

    public MachineInfo findOrCreateMachine(String ip) {
        MachineInfo info = (MachineInfo)this.m_machines.get(ip);
        if (info == null) {
            info = new MachineInfo(ip);
            this.m_machines.put(ip, info);
        }
        return info;
    }

    public void visitDuration(Duration duration) {
        int count = duration.getCount();
        MachineInfo info = this.findOrCreateMachine(this.m_currentIp);
        this.buildMachineDetail(count, info);
        this.buildMachineDetail(count, this.m_allMachine);
    }

    public void visitEntity(Entity entity) {
        this.m_currentType = entity.getType();
        this.m_currentName = entity.getStatus();
        super.visitEntity(entity);
    }

    public void visitMachine(Machine machine) {
        this.m_currentIp = machine.getIp();
        super.visitMachine(machine);
    }

    public void visitProblemReport(ProblemReport problemReport) {
        super.visitProblemReport(problemReport);
        this.m_dailyGraphs.add(this.buildDailyGraph(problemReport, this.m_allMachine));
        for (MachineInfo info : this.m_machines.values()) {
            DailyGraph graph = this.buildDailyGraph(problemReport, info);
            this.m_dailyGraphs.add(graph);
        }
    }
}

