/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.task;

import com.dianping.cat.consumer.problem.model.entity.JavaThread;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.entity.Segment;
import com.dianping.cat.core.dal.Graph;
import com.dianping.cat.report.task.GraphLine;
import com.dianping.cat.report.task.TaskHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemGraphCreator {
    public List<Graph> splitReportToGraphs(Date reportPeriod, String reportDomain, String reportName, ProblemReport report) {
        Set ips = report.getIps();
        ArrayList<Graph> graphs = new ArrayList<Graph>(ips.size() + 1);
        TreeMap<String, GraphLine> allDetailCache = new TreeMap<String, GraphLine>();
        TreeMap<String, GraphLine> allSummaryCache = new TreeMap<String, GraphLine>();
        for (String ip : ips) {
            Object entity22;
            TreeMap detailCache = new TreeMap();
            TreeMap<String, GraphLine> treeMap = new TreeMap<String, GraphLine>();
            Graph graph = new Graph();
            graph.setIp(ip);
            graph.setDomain(reportDomain);
            graph.setName(reportName);
            graph.setPeriod(reportPeriod);
            graph.setType(3);
            Machine machine = report.findOrCreateMachine(ip);
            for (Object entity22 : machine.getEntities().values()) {
                Map threads = entity22.getThreads();
                String type = entity22.getType();
                String status = entity22.getStatus();
                for (Map.Entry problemEntry : threads.entrySet()) {
                    JavaThread thread = (JavaThread)problemEntry.getValue();
                    for (Map.Entry segmentEntry : thread.getSegments().entrySet()) {
                        Segment segment = (Segment)segmentEntry.getValue();
                        int minute = segment.getId();
                        int count = segment.getMessages().size();
                        String summaryKey = type;
                        GraphLine summaryLine = (GraphLine)treeMap.get(summaryKey);
                        if (summaryLine == null) {
                            summaryLine = new GraphLine();
                            summaryLine.minuteCounts = new int[60];
                            treeMap.put(summaryKey, summaryLine);
                        }
                        summaryLine.totalCount += (long)count;
                        summaryLine.minuteCounts[minute] = summaryLine.minuteCounts[minute] + count;
                        GraphLine allSummaryLine = (GraphLine)allSummaryCache.get(summaryKey);
                        if (allSummaryLine == null) {
                            allSummaryLine = new GraphLine();
                            allSummaryLine.minuteCounts = new int[60];
                            allSummaryCache.put(summaryKey, allSummaryLine);
                        }
                        allSummaryLine.totalCount += (long)count;
                        allSummaryLine.minuteCounts[minute] = allSummaryLine.minuteCounts[minute] + count;
                        String detailKey = type + "\t" + status;
                        GraphLine detailLine = (GraphLine)detailCache.get(detailKey);
                        if (detailLine == null) {
                            detailLine = new GraphLine();
                            detailLine.minuteCounts = new int[60];
                            detailCache.put(detailKey, detailLine);
                        }
                        detailLine.totalCount += (long)count;
                        detailLine.minuteCounts[minute] = detailLine.minuteCounts[minute] + count;
                        GraphLine allDetailLine = (GraphLine)allDetailCache.get(detailKey);
                        if (allDetailLine == null) {
                            allDetailLine = new GraphLine();
                            allDetailLine.minuteCounts = new int[60];
                            allDetailCache.put(detailKey, allDetailLine);
                        }
                        allDetailLine.totalCount += (long)count;
                        allDetailLine.minuteCounts[minute] = allDetailLine.minuteCounts[minute] + count;
                    }
                }
            }
            StringBuilder summaryBuilder = new StringBuilder();
            entity22 = treeMap.entrySet().iterator();
            while (entity22.hasNext()) {
                Map.Entry summaryEntry = (Map.Entry)entity22.next();
                GraphLine summaryLine = (GraphLine)summaryEntry.getValue();
                summaryBuilder.append((String)summaryEntry.getKey());
                summaryBuilder.append("\t");
                summaryBuilder.append(summaryLine.totalCount);
                summaryBuilder.append("\t");
                summaryBuilder.append(TaskHelper.join((int[])summaryLine.minuteCounts, (char)','));
                summaryBuilder.append("\n");
            }
            graph.setSummaryContent(summaryBuilder.toString());
            StringBuilder detailBuilder = new StringBuilder();
            for (Map.Entry detailEntry : detailCache.entrySet()) {
                GraphLine detailLine = (GraphLine)detailEntry.getValue();
                detailBuilder.append((String)detailEntry.getKey());
                detailBuilder.append("\t");
                detailBuilder.append(detailLine.totalCount);
                detailBuilder.append("\t");
                detailBuilder.append(TaskHelper.join((int[])detailLine.minuteCounts, (char)','));
                detailBuilder.append("\n");
            }
            graph.setDetailContent(detailBuilder.toString());
            graph.setCreationDate(new Date());
            graphs.add(graph);
        }
        Graph allGraph = new Graph();
        allGraph.setIp("all");
        allGraph.setDomain(reportDomain);
        allGraph.setName(reportName);
        allGraph.setPeriod(reportPeriod);
        allGraph.setType(3);
        StringBuilder summaryBuilder = new StringBuilder();
        for (Map.Entry entry : allSummaryCache.entrySet()) {
            GraphLine summaryLine = (GraphLine)entry.getValue();
            summaryBuilder.append((String)entry.getKey());
            summaryBuilder.append("\t");
            summaryBuilder.append(summaryLine.totalCount);
            summaryBuilder.append("\t");
            summaryBuilder.append(TaskHelper.join((int[])summaryLine.minuteCounts, (char)','));
            summaryBuilder.append("\n");
        }
        allGraph.setSummaryContent(summaryBuilder.toString());
        StringBuilder detailBuilder = new StringBuilder();
        for (Map.Entry detailEntry : allDetailCache.entrySet()) {
            GraphLine detailLine = (GraphLine)detailEntry.getValue();
            detailBuilder.append((String)detailEntry.getKey());
            detailBuilder.append("\t");
            detailBuilder.append(detailLine.totalCount);
            detailBuilder.append("\t");
            detailBuilder.append(TaskHelper.join((int[])detailLine.minuteCounts, (char)','));
            detailBuilder.append("\n");
        }
        allGraph.setDetailContent(detailBuilder.toString());
        allGraph.setCreationDate(new Date());
        graphs.add(allGraph);
        return graphs;
    }
}

