/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.problem.ProblemReportFilter;
import com.dianping.cat.consumer.problem.ProblemReportMerger;
import com.dianping.cat.consumer.problem.model.IVisitor;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyGraph;
import com.dianping.cat.core.dal.DailyGraphDao;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.Graph;
import com.dianping.cat.core.dal.GraphDao;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.report.page.problem.service.ProblemReportService;
import com.dianping.cat.report.page.problem.task.ProblemDailyGraphCreator;
import com.dianping.cat.report.page.problem.task.ProblemGraphCreator;
import com.dianping.cat.report.page.problem.task.ProblemMerger;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemReportBuilder
implements TaskBuilder {
    public static final String ID = "problem";
    @Inject
    protected GraphDao m_graphDao;
    @Inject
    protected DailyGraphDao m_dailyGraphDao;
    @Inject
    protected ProblemReportService m_reportService;
    @Inject
    private ProblemGraphCreator m_problemGraphCreator;
    @Inject
    private ProblemMerger m_problemMerger;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            ProblemReport problemReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
            this.buildProblemDailyGraph(problemReport);
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((ProblemReport)problemReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private List<Graph> buildHourlyGraphs(String name, String domain, Date period) throws DalException {
        long startTime = period.getTime();
        ProblemReport report = (ProblemReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
        return this.m_problemGraphCreator.splitReportToGraphs(period, domain, ID, report);
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        try {
            List graphs = this.buildHourlyGraphs(name, domain, period);
            if (graphs != null) {
                for (Graph graph : graphs) {
                    this.m_graphDao.insert(graph);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        ProblemReport problemReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        new ProblemReportFilter().visitProblemReport(problemReport);
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ProblemReport)problemReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    private void buildProblemDailyGraph(ProblemReport report) {
        try {
            ProblemDailyGraphCreator creator = new ProblemDailyGraphCreator();
            creator.visitProblemReport(report);
            List graphs = creator.buildDailyGraph();
            for (DailyGraph temp : graphs) {
                this.m_dailyGraphDao.insert(temp);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        ProblemReport problemReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ProblemReport)problemReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private ProblemReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        ProblemReportMerger merger = new ProblemReportMerger(new ProblemReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                ProblemReport reportModel = (ProblemReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        ProblemReport problemReport = merger.getProblemReport();
        problemReport.setStartTime(start);
        problemReport.setEndTime(end);
        return problemReport;
    }

    private ProblemReport queryHourlyReportsByDuration(String name, String domain, Date start, Date end) throws DalException {
        Set domainSet = this.m_reportService.queryAllDomainNames(start, end, ID);
        ArrayList<ProblemReport> reports = new ArrayList<ProblemReport>();
        long endTime = end.getTime();
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            ProblemReport report = (ProblemReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
            reports.add(report);
        }
        return this.m_problemMerger.mergeForDaily(domain, reports, domainSet);
    }
}

