/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.transform;

import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.Segment;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.report.graph.LineChart;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;

public class HourlyLineChartVisitor
extends BaseVisitor {
    private String m_ip;
    private String m_type;
    private String m_state;
    private LineChart m_graphItem = new LineChart();
    private Date m_start;
    private Map<Integer, Integer> m_value = new LinkedHashMap();
    private static final int SIZE = 60;

    public HourlyLineChartVisitor(String ip, String type, String state, Date start) {
        this.m_ip = ip;
        this.m_type = type;
        this.m_state = state;
        this.m_start = start;
        this.m_graphItem.setSize(60);
        this.m_graphItem.setStep(60000L);
        this.m_graphItem.setStart(start);
    }

    private String buildSubTitle() {
        String subTitle = this.m_type;
        if (!StringUtils.isEmpty((String)this.m_state)) {
            subTitle = subTitle + ":" + this.m_state;
        }
        return subTitle;
    }

    public LineChart getGraphItem() {
        Double[] value = new Double[60];
        long minute = System.currentTimeMillis() / 1000L / 60L % 60L;
        long current = System.currentTimeMillis();
        current -= current % 3600000L;
        long size = (int)minute + 1;
        if (this.m_start.getTime() < current) {
            size = 60L;
        }
        int i = 0;
        while ((long)i < size) {
            value[i] = 0.0;
            ++i;
        }
        for (i = 0; i < 60; ++i) {
            Integer temp = (Integer)this.m_value.get(i);
            if (temp == null) continue;
            value[i] = temp.doubleValue();
        }
        this.m_graphItem.add(this.buildSubTitle(), value);
        return this.m_graphItem;
    }

    public void visitEntity(Entity entity) {
        String type = entity.getType();
        String state = entity.getStatus();
        if (this.m_state == null) {
            if (type.equals(this.m_type)) {
                super.visitEntity(entity);
            }
        } else if (type.equals(this.m_type) && state.equals(this.m_state)) {
            super.visitEntity(entity);
        }
    }

    public void visitMachine(Machine machine) {
        if ("All".equals(this.m_ip) || this.m_ip.equals(machine.getIp())) {
            super.visitMachine(machine);
        }
    }

    public void visitSegment(Segment segment) {
        int minute = segment.getId();
        int count = segment.getCount();
        Integer temp = (Integer)this.m_value.get(minute);
        if (temp == null) {
            this.m_value.put(minute, count);
        } else {
            this.m_value.put(minute, count + temp);
        }
    }
}

