/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.transform;

import com.dianping.cat.consumer.problem.ProblemType;
import com.dianping.cat.consumer.problem.model.entity.Duration;
import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.report.page.problem.LongConfig;
import com.dianping.cat.report.page.problem.transform.ProblemStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemStatistics
extends BaseVisitor {
    private Map<String, TypeStatistics> m_status = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
    private boolean m_allIp = false;
    private String m_ip = "";
    private List<String> m_ips;
    private LongConfig m_longConfig = new LongConfig();

    private List<Duration> getDurationsByType(String type, Entity entity) {
        ArrayList<Duration> durations = new ArrayList<Duration>();
        if (ProblemType.LONG_URL.getName().equals(type)) {
            for (Map.Entry temp : entity.getDurations().entrySet()) {
                if ((Integer)temp.getKey() < this.m_longConfig.getUrlThreshold()) continue;
                durations.add((Duration)temp.getValue());
            }
        } else if (ProblemType.LONG_SQL.getName().equals(type)) {
            for (Map.Entry temp : entity.getDurations().entrySet()) {
                if ((Integer)temp.getKey() < this.m_longConfig.getSqlThreshold()) continue;
                durations.add((Duration)temp.getValue());
            }
        } else if (ProblemType.LONG_SERVICE.getName().equals(type)) {
            for (Map.Entry temp : entity.getDurations().entrySet()) {
                if ((Integer)temp.getKey() < this.m_longConfig.getServiceThreshold()) continue;
                durations.add((Duration)temp.getValue());
            }
        } else if (ProblemType.LONG_CALL.getName().equals(type)) {
            for (Map.Entry temp : entity.getDurations().entrySet()) {
                if ((Integer)temp.getKey() < this.m_longConfig.getCallThreshold()) continue;
                durations.add((Duration)temp.getValue());
            }
        } else if (ProblemType.LONG_CACHE.getName().equals(type)) {
            for (Map.Entry temp : entity.getDurations().entrySet()) {
                if ((Integer)temp.getKey() < this.m_longConfig.getCacheThreshold()) continue;
                durations.add((Duration)temp.getValue());
            }
        } else {
            durations.add((Duration)entity.getDurations().get(0));
        }
        return durations;
    }

    public List<String> getIps() {
        return this.m_ips;
    }

    public Map<String, TypeStatistics> getStatus() {
        return this.m_status;
    }

    public ProblemStatistics setAllIp(boolean allIp) {
        this.m_allIp = allIp;
        return this;
    }

    public ProblemStatistics setIp(String ip) {
        this.m_ip = ip;
        return this;
    }

    public void setIps(List<String> ips) {
        this.m_ips = ips;
    }

    public ProblemStatistics setLongConfig(LongConfig config) {
        this.m_longConfig = config;
        return this;
    }

    private void statisticsDuration(Entity entity) {
        String type = entity.getType();
        String status = entity.getStatus();
        List durations = this.getDurationsByType(type, entity);
        for (Duration duration : durations) {
            TypeStatistics statusValue = (TypeStatistics)this.m_status.get(type);
            if (statusValue == null) {
                statusValue = new TypeStatistics(type);
                this.m_status.put(type, statusValue);
            }
            statusValue.statics(status, duration);
        }
    }

    public void visitMachine(Machine machine) {
        if (this.m_allIp || this.m_ip.equals(machine.getIp())) {
            Collection entities = machine.getEntities().values();
            for (Entity entity : entities) {
                this.statisticsDuration(entity);
            }
        }
    }
}

