/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.state.Action;
import com.dianping.cat.report.page.state.Context;
import com.dianping.cat.report.page.state.Handler;
import com.dianping.cat.report.page.state.JspViewer;
import com.dianping.cat.report.page.state.Model;
import com.dianping.cat.report.page.state.Payload;
import com.dianping.cat.report.page.state.StateBuilder;
import com.dianping.cat.report.page.state.StateDisplay;
import com.dianping.cat.report.page.state.StateGraphBuilder;
import com.dianping.cat.report.page.state.service.StateReportService;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private StateReportService m_reportService;
    @Inject
    private StateGraphBuilder m_stateGraphs;
    @Inject
    private StateBuilder m_stateBuilder;
    @Inject(type=ModelService.class, value={"state"})
    private ModelService<StateReport> m_service;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;

    private void buildDisplayInfo(Model model, Payload payload, StateReport report) {
        StateDisplay display = new StateDisplay(payload.getIpAddress(), this.m_serverFilterConfigManager.getUnusedDomains());
        display.setSortType(payload.getSort());
        display.visitStateReport(report);
        model.setState(display);
        model.setReport(report);
    }

    public StateReport getHistoryReport(Payload payload) {
        String domain = "cat";
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        return (StateReport)this.m_reportService.queryReport(domain, start, end);
    }

    private StateReport getHourlyReport(Payload payload) {
        String domain = "cat";
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("ip", payload.getIpAddress());
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            return (StateReport)response.getModel();
        }
        throw new RuntimeException("Internal error: no eligable sql service registered for " + request + "!");
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="state")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="state")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        this.normalize(model, payload);
        String key = payload.getKey();
        StateReport report = null;
        Pair pair = null;
        switch (1.$SwitchMap$com$dianping$cat$report$page$state$Action[action.ordinal()]) {
            case 1: {
                report = this.getHourlyReport(payload);
                model.setMessage(this.m_stateBuilder.buildStateMessage(payload.getDate(), payload.getIpAddress()));
                this.buildDisplayInfo(model, payload, report);
                break;
            }
            case 2: {
                report = this.getHistoryReport(payload);
                this.buildDisplayInfo(model, payload, report);
                break;
            }
            case 3: {
                report = this.getHourlyReport(payload);
                pair = this.m_stateGraphs.buildGraph(payload, key, report);
                model.setGraph(new JsonBuilder().toJson(pair.getKey()));
                model.setPieChart(new JsonBuilder().toJson(pair.getValue()));
                break;
            }
            case 4: {
                pair = this.m_stateGraphs.buildGraph(payload, key);
                model.setGraph(new JsonBuilder().toJson(pair.getKey()));
                model.setPieChart(new JsonBuilder().toJson(pair.getValue()));
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.STATE);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        String ip = payload.getIpAddress();
        if (StringUtils.isEmpty((String)ip)) {
            payload.setIpAddress("All");
        }
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
    }
}

