/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.consumer.state.model.entity.Machine;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateBuilder {
    @Inject
    private RouterConfigManager m_routerManager;
    @Inject(type=ModelService.class, value={"state"})
    private ModelService<StateReport> m_stateService;
    private static final int COUNT = 5000000;

    public String buildStateMessage(long date, String ip) {
        StateReport report = this.queryHourlyReport(date, ip);
        if (report != null) {
            int realSize = report.getMachines().size();
            List servers = this.queryAllServers();
            int excepeted = servers.size();
            HashSet<String> errorServers = new HashSet<String>();
            if (realSize != excepeted) {
                for (String serverIp : servers) {
                    if (report.getMachines().get(serverIp) != null) continue;
                    errorServers.add(serverIp);
                }
            }
            for (Machine machine : report.getMachines().values()) {
                if (machine.getTotalLoss() <= 5000000L) continue;
                errorServers.add(machine.getIp());
            }
            if (errorServers.size() > 0) {
                return ((Object)errorServers).toString();
            }
        }
        return null;
    }

    private List<String> queryAllServers() {
        ArrayList<String> strs = new ArrayList<String>();
        String backUpServer = this.m_routerManager.getRouterConfig().getBackupServer();
        List servers = this.m_routerManager.getRouterConfig().getDefaultServers();
        for (DefaultServer server : servers) {
            strs.add(server.getId());
        }
        strs.add(backUpServer);
        return strs;
    }

    private StateReport queryHourlyReport(long date, String ip) {
        String domain = "cat";
        ModelRequest request = new ModelRequest(domain, date).setProperty("ip", ip);
        if (this.m_stateService.isEligable(request)) {
            ModelResponse response = this.m_stateService.invoke(request);
            return (StateReport)response.getModel();
        }
        throw new RuntimeException("Internal error: no eligable sql service registered for " + request + "!");
    }
}

