/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.consumer.state.model.entity.Detail;
import com.dianping.cat.consumer.state.model.entity.Machine;
import com.dianping.cat.consumer.state.model.entity.Message;
import com.dianping.cat.consumer.state.model.entity.ProcessDomain;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.consumer.state.model.transform.BaseVisitor;
import com.dianping.cat.report.page.state.StateDisplay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateDisplay
extends BaseVisitor {
    protected String m_ip;
    private String m_sortType;
    protected ProcessDomain m_processDomain;
    private Set<String> m_fakeDomains;
    protected StateReport m_stateReport = new StateReport();

    public StateDisplay(String ip, Set<String> fakeDomains) {
        this.m_ip = ip;
        this.m_fakeDomains = fakeDomains;
    }

    public Machine getMachine() {
        return this.m_stateReport.findOrCreateMachine(this.m_ip);
    }

    public Map<Long, Message> getMessages() {
        return this.getMachine().getMessages();
    }

    public ProcessDomain getProcessDomain(String name) {
        return this.getMachine().findOrCreateProcessDomain(name);
    }

    public List<ProcessDomain> getProcessDomains() {
        ArrayList<ProcessDomain> domains = new ArrayList<ProcessDomain>(this.m_stateReport.findMachine(this.m_ip).getProcessDomains().values());
        if (this.m_sortType == null) {
            Collections.sort(domains, new SizeCompartor());
        } else if (this.m_sortType.equals("total")) {
            Collections.sort(domains, new TotalCompartor());
        } else if (this.m_sortType.equals("loss")) {
            Collections.sort(domains, new LossCompartor());
        } else if (this.m_sortType.equals("size")) {
            Collections.sort(domains, new SizeCompartor());
        } else if (this.m_sortType.equals("avg")) {
            Collections.sort(domains, new AvgCompartor());
        } else if (this.m_sortType.equals("machine")) {
            Collections.sort(domains, new MachineCompartor());
        } else {
            Collections.sort(domains, new DomainCompartor());
        }
        return domains;
    }

    public StateReport getStateReport() {
        return this.m_stateReport;
    }

    public int getTotalSize() {
        HashSet<String> ips = new HashSet<String>();
        for (ProcessDomain process : this.getMachine().getProcessDomains().values()) {
            Set temp = process.getIps();
            for (String ip : temp) {
                if (!this.validateIp(ip)) continue;
                ips.add(ip);
            }
        }
        return ips.size();
    }

    protected Detail mergeDetail(ProcessDomain processDomain, Detail other) {
        Detail old = processDomain.findOrCreateDetail(other.getId());
        old.setSize(old.getSize() + other.getSize());
        old.setTotal(old.getTotal() + other.getTotal());
        old.setTotalLoss(old.getTotalLoss() + other.getTotalLoss());
        return old;
    }

    protected ProcessDomain mergeProcessDomain(ProcessDomain other, String name) {
        ProcessDomain old = this.getMachine().findOrCreateProcessDomain(name);
        old.setSize(old.getSize() + other.getSize());
        old.setTotal(old.getTotal() + other.getTotal());
        old.setTotalLoss(old.getTotalLoss() + other.getTotalLoss());
        old.setAvg(old.getTotal() > 0L ? old.getSize() / (double)old.getTotal() : 0.0);
        return old;
    }

    protected Machine mergerMachine(Machine old, Machine other) {
        old.setAvgTps(old.getAvgTps() + other.getAvgTps());
        old.setTotal(old.getTotal() + other.getTotal());
        old.setTotalLoss(old.getTotalLoss() + other.getTotalLoss());
        old.setDump(old.getDump() + other.getDump());
        old.setDumpLoss(old.getDumpLoss() + other.getDumpLoss());
        old.setSize(old.getSize() + other.getSize());
        old.setDelaySum(old.getDelaySum() + other.getDelaySum());
        old.setDelayCount(old.getDelayCount() + other.getDelayCount());
        old.setBlockTotal(old.getBlockTotal() + other.getBlockTotal());
        old.setBlockLoss(old.getBlockLoss() + other.getBlockLoss());
        old.setBlockTime(old.getBlockTime() + other.getBlockTime());
        old.setPigeonTimeError(old.getPigeonTimeError() + other.getPigeonTimeError());
        old.setNetworkTimeError(old.getNetworkTimeError() + other.getNetworkTimeError());
        if (other.getMaxTps() > old.getMaxTps()) {
            old.setMaxTps(other.getMaxTps());
        }
        long count = old.getDelayCount();
        double sum = old.getDelaySum();
        if (count > 0L) {
            old.setDelayAvg(sum / (double)count);
        }
        return old;
    }

    public void setSortType(String sort) {
        this.m_sortType = sort;
    }

    public boolean validateIp(String str) {
        Pattern pattern = Pattern.compile("^((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])$");
        return pattern.matcher(str).matches();
    }

    public void visitDetail(Detail detail) {
        this.mergeDetail(this.m_processDomain, detail);
    }

    public void visitMachine(Machine machine) {
        String ip = machine.getIp();
        if (this.m_ip.equals("All") || this.m_ip.equalsIgnoreCase(ip)) {
            Machine m = this.getMachine();
            this.mergerMachine(m, machine);
            super.visitMachine(machine);
        }
    }

    public void visitMessage(Message message) {
        Message total = this.getMachine().findOrCreateMessage(message.getId());
        total.setDelayCount(total.getDelayCount() + message.getDelayCount());
        total.setDelaySum(total.getDelaySum() + message.getDelaySum());
        total.setDump(total.getDump() + message.getDump());
        total.setDumpLoss(total.getDumpLoss() + message.getDumpLoss());
        total.setSize(total.getSize() + message.getSize());
        total.setTotal(total.getTotal() + message.getTotal());
        total.setTotalLoss(total.getTotalLoss() + message.getTotalLoss());
        total.setBlockTotal(total.getBlockTotal() + message.getBlockTotal());
        total.setBlockLoss(total.getBlockLoss() + message.getBlockLoss());
        total.setBlockTime(total.getBlockTime() + message.getBlockTime());
        total.setPigeonTimeError(total.getPigeonTimeError() + message.getPigeonTimeError());
        total.setNetworkTimeError(total.getNetworkTimeError() + message.getNetworkTimeError());
    }

    public void visitProcessDomain(ProcessDomain processDomain) {
        this.m_processDomain = this.mergeProcessDomain(processDomain, processDomain.getName());
        for (String ip : processDomain.getIps()) {
            if (this.m_fakeDomains.contains(ip)) continue;
            this.m_processDomain.getIps().add(ip);
        }
        super.visitProcessDomain(processDomain);
    }

    public void visitStateReport(StateReport stateReport) {
        this.m_stateReport.setDomain(stateReport.getDomain()).setStartTime(stateReport.getStartTime()).setEndTime(stateReport.getEndTime());
        super.visitStateReport(stateReport);
    }
}

