/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.consumer.state.model.entity.Machine;
import com.dianping.cat.consumer.state.model.entity.ProcessDomain;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.consumer.state.model.transform.BaseVisitor;
import java.util.HashMap;
import java.util.Map;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateDistirbutionVisitor
extends BaseVisitor {
    private Map<String, Double> m_distribute = new HashMap();
    private String m_currentIp;
    private String m_domain = "";
    private String m_attribute = "";

    public StateDistirbutionVisitor(String key) {
        int index = key.indexOf(":");
        if (index > -1) {
            this.m_domain = key.substring(0, index);
            this.m_attribute = key.substring(index + 1);
        } else {
            this.m_attribute = key;
        }
    }

    public Map<String, Double> getDistribute() {
        return this.m_distribute;
    }

    private void incDistribute(String ip, double value) {
        if (value > 0.0) {
            Double old = (Double)this.m_distribute.get(ip);
            if (old == null) {
                old = new Double(0.0);
            }
            this.m_distribute.put(ip, old + value);
        }
    }

    private double queryValue(String key, Machine machine) {
        double value = 0.0;
        if (key.equalsIgnoreCase("total")) {
            value = machine.getTotal();
        } else if (key.equalsIgnoreCase("totalLoss")) {
            value = machine.getTotalLoss();
        } else if (key.equalsIgnoreCase("avgTps")) {
            value = machine.getAvgTps();
        } else if (key.equalsIgnoreCase("maxTps")) {
            value = machine.getMaxTps();
        } else if (key.equalsIgnoreCase("dump")) {
            value = machine.getDump();
        } else if (key.equalsIgnoreCase("dumpLoss")) {
            value = machine.getDumpLoss();
        } else if (key.equalsIgnoreCase("pigeonTimeError")) {
            value = machine.getPigeonTimeError();
        } else if (key.equalsIgnoreCase("networkTimeError")) {
            value = machine.getNetworkTimeError();
        } else if (key.equalsIgnoreCase("blockTotal")) {
            value = machine.getBlockTotal();
        } else if (key.equalsIgnoreCase("blockLoss")) {
            value = machine.getBlockLoss();
        } else if (key.equalsIgnoreCase("blockTime")) {
            value = (double)machine.getBlockTime() * 1.0 / 60.0 / 1000.0;
        } else if (key.equalsIgnoreCase("size")) {
            value = machine.getSize() / 1024.0 / 1024.0;
        } else if (key.equalsIgnoreCase("delayAvg") && machine.getDelayCount() > 0) {
            value = machine.getDelaySum() / (double)machine.getDelayCount();
        }
        return value;
    }

    private double queryValue(String key, ProcessDomain processDomain) {
        double value = 0.0;
        if (key.equalsIgnoreCase("total")) {
            value = processDomain.getTotal();
        } else if (key.equalsIgnoreCase("totalLoss")) {
            value = processDomain.getTotalLoss();
        } else if (key.equalsIgnoreCase("size")) {
            value = processDomain.getSize() / 1024.0 / 1024.0;
        }
        return value;
    }

    public void visitMachine(Machine machine) {
        this.m_currentIp = machine.getIp();
        if (StringUtils.isEmpty((String)this.m_domain)) {
            this.incDistribute(this.m_currentIp, this.queryValue(this.m_attribute, machine));
        } else {
            super.visitMachine(machine);
        }
    }

    public void visitProcessDomain(ProcessDomain processDomain) {
        if (this.m_domain.equals(processDomain.getName())) {
            this.incDistribute(this.m_currentIp, this.queryValue(this.m_attribute, processDomain));
        }
    }

    public void visitStateReport(StateReport stateReport) {
        super.visitStateReport(stateReport);
    }
}

