/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.consumer.state.model.IVisitor;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.page.state.Payload;
import com.dianping.cat.report.page.state.StateDistirbutionVisitor;
import com.dianping.cat.report.page.state.StateHistoryGraphVisitor;
import com.dianping.cat.report.page.state.StateHourlyGraphVisitor;
import com.dianping.cat.report.page.state.service.StateReportService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateGraphBuilder {
    @Inject
    private StateReportService m_reportService;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;

    public Pair<LineChart, PieChart> buildGraph(Payload payload, String key) {
        String domain = payload.getDomain();
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        String ips = payload.getIpAddress();
        return this.buildHistoryGraph(domain, start, end, key, ips);
    }

    public Pair<LineChart, PieChart> buildGraph(Payload payload, String key, StateReport report) {
        String domain = payload.getDomain();
        String ips = payload.getIpAddress();
        return this.buildHourlyGraph(report, domain, key, ips);
    }

    private Pair<LineChart, PieChart> buildHistoryGraph(String domain, Date start, Date end, String key, String ip) {
        ArrayList reports = new ArrayList();
        StateHistoryGraphVisitor builder = new StateHistoryGraphVisitor(ip, start.getTime(), end.getTime(), key);
        StateDistirbutionVisitor visitor = new StateDistirbutionVisitor(key);
        long step = end.getTime() - start.getTime() <= 86400000L ? 3600000L : 86400000L;
        for (long date = start.getTime(); date < end.getTime(); date += step) {
            StateReport report = (StateReport)this.m_reportService.queryReport(domain, new Date(date), new Date(date + step));
            report.accept((IVisitor)builder);
            report.accept((IVisitor)visitor);
        }
        int size = reports.size();
        LineChart linechart = new LineChart();
        linechart.setStart(start).setSize(size).setTitle(key).setStep(step);
        linechart.addSubTitle(key);
        linechart.addValue(builder.getData());
        PieChart piechart = this.buildPiechart(visitor.getDistribute());
        return new Pair((Object)linechart, (Object)piechart);
    }

    private Pair<LineChart, PieChart> buildHourlyGraph(StateReport report, String domain, String key, String ip) {
        LineChart linechart = new LineChart();
        StateHourlyGraphVisitor builder = new StateHourlyGraphVisitor(ip, this.m_serverFilterConfigManager.getUnusedDomains(), key, 60);
        builder.visitStateReport(report);
        linechart.setStart(report.getStartTime()).setSize(60).setTitle(key).setStep(60000L);
        linechart.add(key, builder.getData());
        StateDistirbutionVisitor visitor = new StateDistirbutionVisitor(key);
        visitor.visitStateReport(report);
        Map distributes = visitor.getDistribute();
        PieChart piechart = this.buildPiechart(distributes);
        return new Pair((Object)linechart, (Object)piechart);
    }

    private PieChart buildPiechart(Map<String, Double> distributes) {
        PieChart chart = new PieChart();
        ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
        for (Map.Entry<String, Double> entry : distributes.entrySet()) {
            PieChart.Item item = new PieChart.Item();
            item.setTitle(entry.getKey()).setNumber(entry.getValue().doubleValue());
            items.add(item);
        }
        chart.addItems(items);
        return chart;
    }
}

