/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.consumer.state.model.entity.Detail;
import com.dianping.cat.consumer.state.model.entity.Machine;
import com.dianping.cat.consumer.state.model.entity.Message;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.consumer.state.model.transform.BaseVisitor;

public class StateHistoryGraphVisitor
extends BaseVisitor {
    private double[] m_data = null;
    private String m_ip;
    private long m_start;
    private long m_currentStart;
    private String m_attribute = "";
    private long m_gap;
    private StateReport m_stateReport;

    public StateHistoryGraphVisitor(String ip, long start, long end, String key) {
        this.m_ip = ip;
        this.m_start = start;
        this.m_attribute = key;
        this.m_gap = end - start > 86400000L ? 86400000L : 3600000L;
        int size = (int)((end - start) / this.m_gap);
        this.m_data = new double[size];
    }

    public double[] getData() {
        return this.m_data;
    }

    protected Machine mergerMachine(Machine old, Machine other) {
        old.setAvgTps(old.getAvgTps() + other.getAvgTps());
        old.setTotal(old.getTotal() + other.getTotal());
        old.setTotalLoss(old.getTotalLoss() + other.getTotalLoss());
        old.setDump(old.getDump() + other.getDump());
        old.setDumpLoss(old.getDumpLoss() + other.getDumpLoss());
        old.setSize(old.getSize() + other.getSize());
        old.setDelaySum(old.getDelaySum() + other.getDelaySum());
        old.setDelayCount(old.getDelayCount() + other.getDelayCount());
        old.setBlockTotal(old.getBlockTotal() + other.getBlockTotal());
        old.setBlockLoss(old.getBlockLoss() + other.getBlockLoss());
        old.setBlockTime(old.getBlockTime() + other.getBlockTime());
        old.setPigeonTimeError(old.getPigeonTimeError() + other.getPigeonTimeError());
        old.setNetworkTimeError(old.getNetworkTimeError() + other.getNetworkTimeError());
        if (other.getMaxTps() > old.getMaxTps()) {
            old.setMaxTps(other.getMaxTps());
        }
        long count = old.getDelayCount();
        double sum = old.getDelaySum();
        if (count > 0L) {
            old.setDelayAvg(sum / (double)count);
        }
        return old;
    }

    public void visitDetail(Detail detail) {
    }

    public void visitMachine(Machine machine) {
        String ip = machine.getIp();
        Machine m = this.m_stateReport.findOrCreateMachine(this.m_ip);
        if (this.m_ip.equals("All") || this.m_ip.equalsIgnoreCase(ip)) {
            if (this.m_gap == 3600000L) {
                for (Message message : machine.getMessages().values()) {
                    this.visitMessage(message);
                }
            } else {
                this.mergerMachine(m, machine);
                int day = (int)((this.m_currentStart - this.m_start) / 86400000L);
                if (this.m_attribute.equalsIgnoreCase("total")) {
                    this.m_data[day] = m.getTotal();
                } else if (this.m_attribute.equalsIgnoreCase("totalLoss")) {
                    this.m_data[day] = m.getTotalLoss();
                } else if (this.m_attribute.equalsIgnoreCase("avgTps")) {
                    this.m_data[day] = m.getAvgTps();
                } else if (this.m_attribute.equalsIgnoreCase("maxTps")) {
                    this.m_data[day] = m.getMaxTps();
                } else if (this.m_attribute.equalsIgnoreCase("dump")) {
                    this.m_data[day] = m.getDump();
                } else if (this.m_attribute.equalsIgnoreCase("dumpLoss")) {
                    this.m_data[day] = m.getDumpLoss();
                } else if (this.m_attribute.equalsIgnoreCase("pigeonTimeError")) {
                    this.m_data[day] = m.getPigeonTimeError();
                } else if (this.m_attribute.equalsIgnoreCase("networkTimeError")) {
                    this.m_data[day] = m.getNetworkTimeError();
                } else if (this.m_attribute.equalsIgnoreCase("blockTotal")) {
                    this.m_data[day] = m.getBlockTotal();
                } else if (this.m_attribute.equalsIgnoreCase("blockLoss")) {
                    this.m_data[day] = m.getBlockLoss();
                } else if (this.m_attribute.equalsIgnoreCase("blockTime")) {
                    this.m_data[day] = (double)m.getBlockTime() * 1.0 / 60.0 / 1000.0;
                } else if (this.m_attribute.equalsIgnoreCase("size")) {
                    this.m_data[day] = m.getSize() / 1024.0 / 1024.0;
                } else if (this.m_attribute.equalsIgnoreCase("delayAvg") && m.getDelayCount() > 0) {
                    this.m_data[day] = m.getDelaySum() / (double)m.getDelayCount();
                }
            }
        }
    }

    public void visitMessage(Message message) {
        int hour = (int)((this.m_currentStart - this.m_start) / 3600000L);
        if (this.m_attribute.equalsIgnoreCase("total")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getTotal();
        } else if (this.m_attribute.equalsIgnoreCase("totalLoss")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getTotalLoss();
        } else if (this.m_attribute.equalsIgnoreCase("avgTps")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getTotal();
        } else if (this.m_attribute.equalsIgnoreCase("maxTps")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getTotal();
        } else if (this.m_attribute.equalsIgnoreCase("dump")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getDump();
        } else if (this.m_attribute.equalsIgnoreCase("dumpLoss")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getDumpLoss();
        } else if (this.m_attribute.equalsIgnoreCase("pigeonTimeError")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getPigeonTimeError();
        } else if (this.m_attribute.equalsIgnoreCase("networkTimeError")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getNetworkTimeError();
        } else if (this.m_attribute.equalsIgnoreCase("blockTotal")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getBlockTotal();
        } else if (this.m_attribute.equalsIgnoreCase("blockLoss")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getBlockLoss();
        } else if (this.m_attribute.equalsIgnoreCase("blockTime")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + (double)message.getBlockTime() * 1.0 / 60.0 / 1000.0;
        } else if (this.m_attribute.equalsIgnoreCase("size")) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + message.getSize() / 1024.0 / 1024.0;
        } else if (this.m_attribute.equalsIgnoreCase("delayAvg") && message.getDelayCount() > 0) {
            int n = hour;
            this.m_data[n] = this.m_data[n] + message.getDelaySum() / (double)message.getDelayCount();
        }
    }

    public void visitStateReport(StateReport stateReport) {
        this.m_currentStart = stateReport.getStartTime().getTime();
        this.m_stateReport = new StateReport().setDomain(stateReport.getDomain()).setStartTime(stateReport.getStartTime()).setEndTime(stateReport.getEndTime());
        super.visitStateReport(stateReport);
    }
}

