/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.consumer.state.model.entity.Detail;
import com.dianping.cat.consumer.state.model.entity.Message;
import com.dianping.cat.consumer.state.model.entity.ProcessDomain;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.report.page.state.StateDisplay;
import java.util.Set;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateHourlyGraphVisitor
extends StateDisplay {
    protected Double[] m_data = null;
    protected int m_maxSize;
    protected long m_start;
    protected String m_domain = "";
    protected String m_attribute = "";

    public StateHourlyGraphVisitor(String ip, Set<String> fakeDomains, String key, int maxSize) {
        super(ip, fakeDomains);
        this.m_maxSize = maxSize;
        int index = key.indexOf(":");
        if (index > -1) {
            this.m_domain = key.substring(0, index);
            this.m_attribute = key.substring(index + 1);
        } else {
            this.m_attribute = key;
        }
    }

    public Double[] getData() {
        return this.m_data;
    }

    public void visitDetail(Detail detail) {
        super.visitDetail(detail);
        long id = detail.getId();
        Detail d = this.m_processDomain.findOrCreateDetail(detail.getId());
        int minute = (int)((id - this.m_start) / 60000L);
        if (this.m_attribute.equalsIgnoreCase("total")) {
            this.m_data[minute] = d.getTotal();
        } else if (this.m_attribute.equalsIgnoreCase("totalLoss")) {
            this.m_data[minute] = d.getTotalLoss();
        } else if (this.m_attribute.equalsIgnoreCase("size")) {
            this.m_data[minute] = d.getSize() / 1024.0 / 1024.0;
        }
    }

    public void visitMessage(Message message) {
        if (StringUtils.isEmpty((String)this.m_domain)) {
            super.visitMessage(message);
            long id = message.getId();
            Message msg = this.getMachine().findOrCreateMessage(Long.valueOf(id));
            int minute = (int)(id - this.m_start) / 60000;
            if (this.m_attribute.equalsIgnoreCase("total")) {
                this.m_data[minute] = msg.getTotal();
            } else if (this.m_attribute.equalsIgnoreCase("totalLoss")) {
                this.m_data[minute] = msg.getTotalLoss();
            } else if (this.m_attribute.equalsIgnoreCase("avgTps")) {
                this.m_data[minute] = msg.getTotal();
            } else if (this.m_attribute.equalsIgnoreCase("maxTps")) {
                this.m_data[minute] = msg.getTotal();
            } else if (this.m_attribute.equalsIgnoreCase("dump")) {
                this.m_data[minute] = msg.getDump();
            } else if (this.m_attribute.equalsIgnoreCase("dumpLoss")) {
                this.m_data[minute] = msg.getDumpLoss();
            } else if (this.m_attribute.equalsIgnoreCase("pigeonTimeError")) {
                this.m_data[minute] = msg.getPigeonTimeError();
            } else if (this.m_attribute.equalsIgnoreCase("networkTimeError")) {
                this.m_data[minute] = msg.getNetworkTimeError();
            } else if (this.m_attribute.equalsIgnoreCase("blockTotal")) {
                this.m_data[minute] = msg.getBlockTotal();
            } else if (this.m_attribute.equalsIgnoreCase("blockLoss")) {
                this.m_data[minute] = msg.getBlockLoss();
            } else if (this.m_attribute.equalsIgnoreCase("blockTime")) {
                this.m_data[minute] = (double)msg.getBlockTime() * 1.0 / 60.0 / 1000.0;
            } else if (this.m_attribute.equalsIgnoreCase("size")) {
                this.m_data[minute] = msg.getSize() / 1024.0 / 1024.0;
            } else if (this.m_attribute.equalsIgnoreCase("delayAvg") && msg.getDelayCount() > 0) {
                this.m_data[minute] = msg.getDelaySum() / (double)msg.getDelayCount();
            }
        }
    }

    public void visitProcessDomain(ProcessDomain processDomain) {
        if (StringUtils.isNotEmpty((String)this.m_domain) && this.m_domain.equals(processDomain.getName())) {
            super.visitProcessDomain(processDomain);
        }
    }

    public void visitStateReport(StateReport stateReport) {
        this.m_data = new Double[this.m_maxSize];
        this.m_start = stateReport.getStartTime().getTime();
        long current = System.currentTimeMillis();
        current -= current % 3600000L;
        long size = this.m_maxSize;
        if (this.m_start == current) {
            long minute = System.currentTimeMillis() / 1000L / 60L % 60L;
            size = (int)minute + 1;
        }
        int i = 0;
        while ((long)i < size) {
            this.m_data[i] = 0.0;
            ++i;
        }
        super.visitStateReport(stateReport);
    }
}

