/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state.service;

import com.dianping.cat.consumer.state.StateReportMerger;
import com.dianping.cat.consumer.state.model.IEntity;
import com.dianping.cat.consumer.state.model.IVisitor;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.consumer.state.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.state.service.LocalStateService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalStateService
extends LocalModelService<StateReport> {
    public static final String ID = "state";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalStateService() {
        super(ID);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        long startTime;
        List reports = super.getReport(period, domain);
        StateReport report = null;
        if (reports != null) {
            report = new StateReport(domain);
            StateReportMerger merger = new StateReportMerger(report);
            for (StateReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getMachines().isEmpty()) && period.isLast() && (report = this.getReportFromLocalDisk(startTime = request.getStartTime(), domain)) == null) {
            report = new StateReport(domain);
            report.setStartTime(new Date(startTime));
            report.setEndTime(new Date(startTime + 3600000L - 1L));
        }
        return new StateReportFilter().buildXml((IEntity)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        StateReport report = new StateReport(domain);
        StateReportMerger merger = new StateReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < 2; ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml == null) continue;
                StateReport tmp = DefaultSaxParser.parse((String)xml);
                tmp.accept((IVisitor)merger);
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

