/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state.task;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.state.model.IVisitor;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.consumer.state.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.Hostinfo;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.report.page.state.service.StateReportService;
import com.dianping.cat.report.page.state.task.HistoryStateReportMerger;
import com.dianping.cat.report.page.state.task.StateReportBuilder;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import com.dianping.cat.service.HostinfoService;
import com.dianping.cat.service.ProjectService;
import java.util.Date;
import org.unidal.lookup.annotation.Inject;

public class StateReportBuilder
implements TaskBuilder {
    public static final String ID = "state";
    @Inject
    protected StateReportService m_reportService;
    @Inject
    protected ServerConfigManager m_serverConfigManager;
    @Inject
    protected ServerFilterConfigManager m_serverFilterConfigManager;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private HostinfoService m_hostinfoService;

    public boolean buildDailyTask(String name, String domain, Date period) {
        StateReport stateReport = this.queryHourlyReportsByDuration(domain, period, TaskHelper.tomorrowZero((Date)period));
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((StateReport)stateReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        StateReport stateReport = (StateReport)this.m_reportService.queryReport(domain, period, new Date(period.getTime() + 3600000L));
        new StateReportVisitor(this).visitStateReport(stateReport);
        return true;
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        StateReport stateReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((StateReport)stateReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        Date start = period;
        Date end = new Date(start.getTime() + 604800000L);
        StateReport stateReport = this.queryDailyReportsByDuration(domain, start, end);
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((StateReport)stateReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private StateReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        HistoryStateReportMerger merger = new HistoryStateReportMerger(new StateReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                StateReport reportModel = (StateReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        StateReport stateReport = merger.getStateReport();
        new ClearDetailInfo().visitStateReport(stateReport);
        stateReport.setStartTime(start);
        stateReport.setEndTime(end);
        return stateReport;
    }

    private StateReport queryHourlyReportsByDuration(String domain, Date period, Date endDate) {
        long endTime = endDate.getTime();
        HistoryStateReportMerger merger = new HistoryStateReportMerger(new StateReport(domain));
        for (long startTime = period.getTime(); startTime < endTime; startTime += 3600000L) {
            Date date = new Date(startTime);
            StateReport reportModel = (StateReport)this.m_reportService.queryReport(domain, date, new Date(date.getTime() + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        StateReport stateReport = merger.getStateReport();
        new ClearDetailInfo().visitStateReport(stateReport);
        stateReport.setStartTime(period);
        stateReport.setEndTime(endDate);
        return stateReport;
    }

    private void updateProjectAndHost(String domain, String ip) {
        if (this.m_serverFilterConfigManager.validateDomain(domain)) {
            Hostinfo info;
            if (!this.m_projectService.contains(domain)) {
                this.m_projectService.insert(domain);
            }
            if ((info = this.m_hostinfoService.findByIp(ip)) == null) {
                this.m_hostinfoService.insert(domain, ip);
            } else {
                String oldDomain = info.getDomain();
                if (!domain.equals(oldDomain) && !"cat".equals(oldDomain)) {
                    this.m_hostinfoService.update(info.getId(), domain, ip);
                }
            }
        }
    }

    static /* synthetic */ void access$000(StateReportBuilder x0, String x1, String x2) {
        x0.updateProjectAndHost(x1, x2);
    }
}

