/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics;

import com.dianping.cat.core.dal.Project;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.heavy.entity.HeavyCache;
import com.dianping.cat.home.heavy.entity.HeavyCall;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.entity.HeavySql;
import com.dianping.cat.home.jar.entity.JarReport;
import com.dianping.cat.home.service.entity.Domain;
import com.dianping.cat.home.service.entity.ServiceReport;
import com.dianping.cat.home.system.entity.SystemReport;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.alert.summary.AlertSummaryExecutor;
import com.dianping.cat.report.page.statistics.Action;
import com.dianping.cat.report.page.statistics.Context;
import com.dianping.cat.report.page.statistics.ErrorStatis;
import com.dianping.cat.report.page.statistics.Handler;
import com.dianping.cat.report.page.statistics.JspViewer;
import com.dianping.cat.report.page.statistics.Model;
import com.dianping.cat.report.page.statistics.Payload;
import com.dianping.cat.report.page.statistics.config.BugConfigManager;
import com.dianping.cat.report.page.statistics.service.BugReportService;
import com.dianping.cat.report.page.statistics.service.HeavyReportService;
import com.dianping.cat.report.page.statistics.service.JarReportService;
import com.dianping.cat.report.page.statistics.service.ServiceReportService;
import com.dianping.cat.report.page.statistics.service.SystemReportService;
import com.dianping.cat.report.page.statistics.service.UtilizationReportService;
import com.dianping.cat.report.page.statistics.task.heavy.HeavyReportMerger;
import com.dianping.cat.report.page.statistics.task.jar.JarReportBuilder;
import com.dianping.cat.report.page.statistics.task.system.SystemReportBuilder;
import com.dianping.cat.service.ProjectService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private SystemReportService m_systemReportService;
    @Inject
    private BugReportService m_bugReportService;
    @Inject
    private HeavyReportService m_heavyReportService;
    @Inject
    private UtilizationReportService m_utilizationReportService;
    @Inject
    private ServiceReportService m_serviceReportService;
    @Inject
    private JarReportService m_jarReportService;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private BugConfigManager m_bugConfigManager;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private AlertSummaryExecutor m_executor;

    private void buildBugInfo(Model model, Payload payload) {
        BugReport bugReport = this.queryBugReport(payload);
        BugReportVisitor visitor = new BugReportVisitor(this);
        visitor.visitBugReport(bugReport);
        Map errors = visitor.getErrors();
        errors = this.sortErrorStatis(errors);
        model.setErrorStatis(errors);
        if (payload.getAction() == Action.BUG_HTTP_JSON) {
            new ClearBugReport(this).visitBugReport(bugReport);
        }
        model.setBugReport(bugReport);
    }

    private void buildHeavyInfo(Model model, Payload payload) {
        HeavyReport heavyReport = this.queryHeavyReport(payload);
        model.setHeavyReport(heavyReport);
        this.buildSortedHeavyInfo(model, heavyReport);
    }

    private void buildJarInfo(Model model, Payload payload) {
        JarReport jarReport = this.queryJarReport(payload);
        model.setJars(JarReportBuilder.s_jars);
        model.setJarReport(jarReport);
    }

    private void buildServiceInfo(Model model, Payload payload) {
        ServiceReport serviceReport = this.queryServiceReport(payload);
        List dHisList = this.sort(serviceReport, payload.getSortBy());
        model.setServiceList(dHisList);
        model.setServiceReport(serviceReport);
    }

    private void buildSortedHeavyInfo(Model model, HeavyReport heavyReport) {
        HeavyCache heavyCache;
        HeavySql heavySql;
        HeavyCall heavyCall = heavyReport.getHeavyCall();
        if (heavyCall != null) {
            ArrayList callUrls = new ArrayList(heavyCall.getUrls().values());
            ArrayList callServices = new ArrayList(heavyCall.getServices().values());
            Collections.sort(callUrls, new HeavyReportMerger.UrlComparator());
            Collections.sort(callServices, new HeavyReportMerger.ServiceComparator());
            model.setCallUrls(callUrls);
            model.setCallServices(callServices);
        }
        if ((heavySql = heavyReport.getHeavySql()) != null) {
            ArrayList sqlUrls = new ArrayList(heavySql.getUrls().values());
            ArrayList sqlServices = new ArrayList(heavySql.getServices().values());
            Collections.sort(sqlUrls, new HeavyReportMerger.UrlComparator());
            Collections.sort(sqlServices, new HeavyReportMerger.ServiceComparator());
            model.setSqlUrls(sqlUrls);
            model.setSqlServices(sqlServices);
        }
        if ((heavyCache = heavyReport.getHeavyCache()) != null) {
            ArrayList cacheUrls = new ArrayList(heavyCache.getUrls().values());
            ArrayList cacheServices = new ArrayList(heavyCache.getServices().values());
            Collections.sort(cacheUrls, new HeavyReportMerger.UrlComparator());
            Collections.sort(cacheServices, new HeavyReportMerger.ServiceComparator());
            model.setCacheUrls(cacheUrls);
            model.setCacheServices(cacheServices);
        }
    }

    private void buildSystemReport(Model model, Payload payload) {
        Date startDate = payload.getDay();
        Date endDate = TimeHelper.addDays((Date)startDate, (int)1);
        SystemReport systemReport = (SystemReport)this.m_systemReportService.queryReport("cat", startDate, endDate);
        model.setSystemReport(systemReport);
        model.setKeys(SystemReportBuilder.KEYS);
    }

    private void buildUtilizationInfo(Model model, Payload payload) {
        UtilizationReport utilizationReport = this.queryUtilizationReport(payload);
        Collection dUList = utilizationReport.getDomains().values();
        LinkedList<com.dianping.cat.home.utilization.entity.Domain> dUWebList = new LinkedList<com.dianping.cat.home.utilization.entity.Domain>();
        LinkedList<com.dianping.cat.home.utilization.entity.Domain> dUServiceList = new LinkedList<com.dianping.cat.home.utilization.entity.Domain>();
        for (com.dianping.cat.home.utilization.entity.Domain d : dUList) {
            if (d.findApplicationState("URL") != null) {
                dUWebList.add(d);
            }
            if (d.findApplicationState("PigeonService") == null) continue;
            dUServiceList.add(d);
        }
        model.setUtilizationWebList(dUWebList);
        model.setUtilizationServiceList(dUServiceList);
        model.setUtilizationReport(utilizationReport);
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="statistics")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="statistics")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        Action action = payload.getAction();
        switch (4.$SwitchMap$com$dianping$cat$report$page$statistics$Action[action.ordinal()]) {
            case 1: 
            case 2: {
                this.buildServiceInfo(model, payload);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.buildBugInfo(model, payload);
                break;
            }
            case 6: 
            case 7: {
                this.buildHeavyInfo(model, payload);
                break;
            }
            case 8: 
            case 9: {
                this.buildUtilizationInfo(model, payload);
                break;
            }
            case 10: {
                String domain = payload.getSummarydomain();
                if (!StringUtils.isNotEmpty((String)domain)) break;
                String summaryContent = this.m_executor.execute(domain, payload.getSummarytime(), payload.getSummaryemails());
                model.setSummaryContent(summaryContent);
                break;
            }
            case 11: {
                this.buildJarInfo(model, payload);
                break;
            }
            case 12: {
                this.buildSystemReport(model, payload);
            }
        }
        model.setPage((Page)ReportPage.STATISTICS);
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private boolean isBug(String domain, String exception) {
        Set bugConfig = this.m_bugConfigManager.queryBugConfigsByDomain(domain);
        return !bugConfig.contains(exception);
    }

    private BugReport queryBugReport(Payload payload) {
        Pair pair = this.queryStartEndTime(payload);
        return (BugReport)this.m_bugReportService.queryReport("cat", (Date)pair.getKey(), (Date)pair.getValue());
    }

    private HeavyReport queryHeavyReport(Payload payload) {
        Pair pair = this.queryStartEndTime(payload);
        return (HeavyReport)this.m_heavyReportService.queryReport("cat", (Date)pair.getKey(), (Date)pair.getValue());
    }

    private JarReport queryJarReport(Payload payload) {
        Pair pair = this.queryStartEndTime(payload);
        return (JarReport)this.m_jarReportService.queryReport("cat", (Date)pair.getKey(), (Date)pair.getValue());
    }

    private ServiceReport queryServiceReport(Payload payload) {
        Pair pair = this.queryStartEndTime(payload);
        return (ServiceReport)this.m_serviceReportService.queryReport("cat", (Date)pair.getKey(), (Date)pair.getValue());
    }

    private Pair<Date, Date> queryStartEndTime(Payload payload) {
        Date start = null;
        Date end = null;
        Action action = payload.getAction();
        String name = action.getName();
        if (!name.startsWith("history") && action != Action.BUG_HTTP_JSON) {
            if (payload.getPeriod().isCurrent()) {
                start = new Date(payload.getDate() - 3600000L);
                end = new Date(start.getTime() + 3600000L);
            } else {
                start = new Date(payload.getDate());
                end = new Date(start.getTime() + 3600000L);
            }
        } else {
            start = payload.getHistoryStartDate();
            end = payload.getHistoryEndDate();
        }
        return new Pair((Object)start, (Object)end);
    }

    private UtilizationReport queryUtilizationReport(Payload payload) {
        Pair pair = this.queryStartEndTime(payload);
        UtilizationReport report = (UtilizationReport)this.m_utilizationReportService.queryReport("cat", (Date)pair.getKey(), (Date)pair.getValue());
        Collection domains = report.getDomains().values();
        for (com.dianping.cat.home.utilization.entity.Domain d : domains) {
            String domain = d.getId();
            Project project = this.m_projectService.findByDomain(domain);
            if (project == null) continue;
            d.setCmdbId(project.getCmdbDomain());
        }
        return report;
    }

    private List<Domain> sort(ServiceReport serviceReport, String sortBy) {
        ArrayList<Domain> result = new ArrayList<Domain>(serviceReport.getDomains().values());
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private Map<String, ErrorStatis> sortErrorStatis(Map<String, ErrorStatis> errors) {
        2 errorCompator = new /* Unavailable Anonymous Inner Class!! */;
        errors = SortHelper.sortMap(errors, (Comparator)errorCompator);
        for (ErrorStatis temp : errors.values()) {
            3 compator = new /* Unavailable Anonymous Inner Class!! */;
            Map bugs = temp.getBugs();
            Map exceptions = temp.getExceptions();
            temp.setBugs(SortHelper.sortMap((Map)bugs, (Comparator)compator));
            temp.setExceptions(SortHelper.sortMap((Map)exceptions, (Comparator)compator));
        }
        return errors;
    }

    static /* synthetic */ ProjectService access$000(Handler x0) {
        return x0.m_projectService;
    }

    static /* synthetic */ boolean access$100(Handler x0, String x1, String x2) {
        return x0.isBug(x1, x2);
    }
}

