/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.bug.config.entity.BugConfig;
import com.dianping.cat.home.bug.config.entity.Domain;
import com.dianping.cat.home.bug.config.transform.DefaultSaxParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugConfigManager
implements Initializable,
LogEnabled {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private BugConfig m_bugConfig;
    private Logger m_logger;
    private static final String CONFIG_NAME = "bugConfig";
    private Map<String, Set<String>> m_configs = new HashMap();

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public BugConfig getBugConfig() {
        return this.m_bugConfig;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_bugConfig = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_bugConfig = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_bugConfig == null) {
            this.m_bugConfig = new BugConfig();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_bugConfig = DefaultSaxParser.parse((String)xml);
            boolean result = this.storeConfig();
            this.m_configs.clear();
            return result;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            this.m_logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Set<String> queryBugConfigsByDomain(String domain) {
        HashSet result = (HashSet)this.m_configs.get(domain);
        if (result == null) {
            result = new HashSet();
            Domain config = this.m_bugConfig.findDomain(domain);
            if (config == null) {
                result = new HashSet(this.m_bugConfig.getExceptions());
            } else if (config.getAdditivity().booleanValue()) {
                result.addAll(this.m_bugConfig.getExceptions());
                result.addAll(config.getExceptions());
            } else {
                result = new HashSet(config.getExceptions());
            }
            this.m_configs.put(domain, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        BugConfigManager bugConfigManager = this;
        synchronized (bugConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_bugConfig.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

