/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.service;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentEntity;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentEntity;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.home.bug.IVisitor;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.transform.DefaultNativeParser;
import com.dianping.cat.report.page.statistics.task.bug.BugReportMerger;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugReportService
extends AbstractReportService<BugReport> {
    public BugReport makeReport(String domain, Date start, Date end) {
        BugReport report = new BugReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public BugReport queryDailyReport(String domain, Date start, Date end) {
        BugReportMerger merger = new BugReportMerger(new BugReport(domain));
        long endTime = end.getTime();
        String name = "bug";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, new Date(startTime), DailyReportEntity.READSET_FULL);
                BugReport reportModel = this.queryFromDailyBinary(report.getId(), domain);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (DalNotFoundException report) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        BugReport bugReport = merger.getBugReport();
        bugReport.setStartTime(start);
        bugReport.setEndTime(end);
        return bugReport;
    }

    private BugReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new BugReport(domain);
    }

    private BugReport queryFromHourlyBinary(int id, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, HourlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new BugReport(domain);
    }

    private BugReport queryFromMonthlyBinary(int id, String domain) throws DalException {
        MonthlyReportContent content = this.m_monthlyReportContentDao.findByPK(id, MonthlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new BugReport(domain);
    }

    private BugReport queryFromWeeklyBinary(int id, String domain) throws DalException {
        WeeklyReportContent content = this.m_weeklyReportContentDao.findByPK(id, WeeklyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new BugReport(domain);
    }

    public BugReport queryHourlyReport(String domain, Date start, Date end) {
        BugReportMerger merger = new BugReportMerger(new BugReport(domain));
        long endTime = end.getTime();
        String name = "bug";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    BugReport reportModel = this.queryFromHourlyBinary(report.getId(), domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        BugReport bugReport = merger.getBugReport();
        bugReport.setStartTime(start);
        bugReport.setEndTime(new Date(end.getTime() - 1L));
        return bugReport;
    }

    public BugReport queryMonthlyReport(String domain, Date start) {
        try {
            MonthlyReport entity = this.m_monthlyReportDao.findReportByDomainNamePeriod(start, domain, "bug", MonthlyReportEntity.READSET_FULL);
            return this.queryFromMonthlyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new BugReport(domain);
    }

    public BugReport queryWeeklyReport(String domain, Date start) {
        try {
            WeeklyReport entity = this.m_weeklyReportDao.findReportByDomainNamePeriod(start, domain, "bug", WeeklyReportEntity.READSET_FULL);
            return this.queryFromWeeklyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new BugReport(domain);
    }
}

