/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.service;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.home.jar.entity.JarReport;
import com.dianping.cat.home.jar.transform.DefaultNativeParser;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarReportService
extends AbstractReportService<JarReport> {
    public JarReport makeReport(String domain, Date start, Date end) {
        throw new RuntimeException("JarReportService do not suppot makeReport feature");
    }

    public JarReport queryDailyReport(String domain, Date start, Date end) {
        throw new RuntimeException("JarReportService do not suppot queryDailyReport feature");
    }

    private JarReport queryFromHourlyBinary(int id, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, HourlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new JarReport();
    }

    public JarReport queryHourlyReport(String domain, Date start, Date end) {
        long endTime = end.getTime();
        String name = "jar";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(start, domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    return this.queryFromHourlyBinary(report.getId(), domain);
                }
                catch (DalException e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        return new JarReport();
    }

    public JarReport queryMonthlyReport(String domain, Date start) {
        throw new RuntimeException("JarReportService do not suppot queryMonthlyReport feature");
    }

    public JarReport queryWeeklyReport(String domain, Date start) {
        throw new RuntimeException("JarReportService do not suppot queryWeeklyReport feature");
    }
}

