/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.bug;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.home.bug.IVisitor;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.entity.Domain;
import com.dianping.cat.home.bug.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.problem.service.ProblemReportService;
import com.dianping.cat.report.page.statistics.service.BugReportService;
import com.dianping.cat.report.page.statistics.task.bug.BugReportMerger;
import com.dianping.cat.report.page.statistics.task.bug.HistoryBugReportMerger;
import com.dianping.cat.report.page.statistics.task.bug.ProblemReportVisitor;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;

public class BugReportBuilder
implements TaskBuilder {
    public static final String ID = "bug";
    @Inject
    protected BugReportService m_reportService;
    @Inject
    protected ProblemReportService m_problemReportService;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;
    private SimpleDateFormat m_hourly_formate = new SimpleDateFormat("yyyyMMddHH");
    private SimpleDateFormat m_daily_formate = new SimpleDateFormat("yyyyMMdd");

    public boolean buildDailyTask(String name, String domain, Date period) {
        BugReport bugReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
        for (Domain d : bugReport.getDomains().values()) {
            d.setProblemUrl(String.format("http://%s/cat/r/p?op=history&reportType=day&domain=%s&date=%s", this.getDomainName(), d.getId(), this.m_daily_formate.format(period)));
        }
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((BugReport)bugReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    public boolean buildHourlyTask(String name, String domain, Date start) {
        BugReport bugReport = new BugReport("cat");
        ProblemReportVisitor visitor = new ProblemReportVisitor().setReport(bugReport);
        Date end = new Date(start.getTime() + 3600000L);
        Set domains = this.m_reportService.queryAllDomainNames(start, end, "problem");
        for (String domainName : domains) {
            if (!this.m_serverFilterConfigManager.validateDomain(domainName)) continue;
            ProblemReport problemReport = (ProblemReport)this.m_problemReportService.queryReport(domainName, start, end);
            visitor.visitProblemReport(problemReport);
        }
        for (Domain d : bugReport.getDomains().values()) {
            d.setProblemUrl(String.format("http://%s/cat/r/p?domain=%s&date=%s", this.getDomainName(), d.getId(), this.m_hourly_formate.format(start)));
        }
        HourlyReport report = new HourlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(start);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((BugReport)bugReport);
        return this.m_reportService.insertHourlyReport(report, binaryContent);
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        BugReport bugReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        for (Domain d : bugReport.getDomains().values()) {
            d.setProblemUrl(String.format("http://%s/cat/r/p?op=history&reportType=month&domain=%s&date=%s", this.getDomainName(), d.getId(), this.m_daily_formate.format(period)));
        }
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((BugReport)bugReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        BugReport bugReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        for (Domain d : bugReport.getDomains().values()) {
            d.setProblemUrl(String.format("http://%s/cat/r/p?op=history&reportType=week&domain=%s&date=%s", this.getDomainName(), d.getId(), this.m_daily_formate.format(period)));
        }
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((BugReport)bugReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private String getDomainName() {
        String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        return ip + ":8080";
    }

    private BugReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        HistoryBugReportMerger merger = new HistoryBugReportMerger(new BugReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                BugReport reportModel = (BugReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        BugReport bugReport = merger.getBugReport();
        bugReport.setStartTime(start);
        bugReport.setEndTime(end);
        return bugReport;
    }

    private BugReport queryHourlyReportsByDuration(String name, String domain, Date start, Date end) {
        long endTime = end.getTime();
        BugReportMerger merger = new BugReportMerger(new BugReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            Date date = new Date(startTime);
            BugReport reportModel = (BugReport)this.m_reportService.queryReport(domain, date, new Date(date.getTime() + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        BugReport bugReport = merger.getBugReport();
        return bugReport;
    }
}

