/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.bug;

import com.dianping.cat.consumer.problem.ProblemType;
import com.dianping.cat.consumer.problem.model.entity.Duration;
import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.entity.Domain;
import com.dianping.cat.home.bug.entity.ExceptionItem;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemReportVisitor
extends BaseVisitor {
    private BugReport m_report;
    private String m_currentDomain;
    private String m_exception;
    private int SIZE = 10;

    public BugReport getReport() {
        return this.m_report;
    }

    protected void mergeList(List<String> oldMessages, List<String> newMessages, int size) {
        int originalSize = oldMessages.size();
        if (originalSize < size) {
            int remainingSize = size - originalSize;
            if (remainingSize >= newMessages.size()) {
                oldMessages.addAll(newMessages);
            } else {
                oldMessages.addAll(newMessages.subList(0, remainingSize));
            }
        }
    }

    public ProblemReportVisitor setReport(BugReport report) {
        this.m_report = report;
        return this;
    }

    public void visitDuration(Duration duration) {
        int count = duration.getCount();
        Domain domainInfo = this.m_report.findOrCreateDomain(this.m_currentDomain);
        ExceptionItem target = domainInfo.findOrCreateExceptionItem(this.m_exception);
        List oldMessages = target.getMessages();
        List newMessages = duration.getMessages();
        target.setCount(target.getCount() + count);
        this.mergeList(oldMessages, newMessages, this.SIZE);
    }

    public void visitEntity(Entity entity) {
        String type = entity.getType();
        if (ProblemType.ERROR.getName().equals(type)) {
            this.m_exception = entity.getStatus();
            super.visitEntity(entity);
        }
    }

    public void visitProblemReport(ProblemReport problemReport) {
        this.m_currentDomain = problemReport.getDomain();
        super.visitProblemReport(problemReport);
    }
}

