/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.jar;

import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.home.jar.entity.JarReport;
import com.dianping.cat.home.jar.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.heartbeat.service.HeartbeatReportService;
import com.dianping.cat.report.page.statistics.service.JarReportService;
import com.dianping.cat.report.page.statistics.task.jar.JarReportBuilder;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;

public class JarReportBuilder
implements TaskBuilder {
    public static final String ID = "jar";
    @Inject
    private JarReportService m_reportService;
    @Inject
    private HeartbeatReportService m_heartbeatReportService;
    @Inject
    private ServerFilterConfigManager m_configManager;
    public static List<String> s_jars = Arrays.asList("cat-client", "cat-core", "dpsf-net", "lion-client", "avatar-cache", "zebra-ds-monitor-client", "zebra-api", "swallow-client", "swallow-consumerclient", "swallow-producerclient", "platform-sdk");

    public boolean buildDailyTask(String name, String domain, Date period) {
        throw new RuntimeException("jar don't support daily update");
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        Date end = new Date(period.getTime() + 3600000L);
        Set domains = this.m_reportService.queryAllDomainNames(period, end, "heartbeat");
        JarReport jarReport = new JarReport();
        HeartbeatReportVisitor visitor = new HeartbeatReportVisitor(this, jarReport);
        for (String domainName : domains) {
            if (!this.m_configManager.validateDomain(domainName)) continue;
            HeartbeatReport heartbeatReport = (HeartbeatReport)this.m_heartbeatReportService.queryReport(domainName, period, end);
            visitor.visitHeartbeatReport(heartbeatReport);
        }
        jarReport.setStartTime(period);
        jarReport.setEndTime(end);
        HourlyReport report = new HourlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((JarReport)jarReport);
        return this.m_reportService.insertHourlyReport(report, binaryContent);
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("jar don't support monthly update");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("jar don't support weekly update");
    }
}

