/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.system;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.system.entity.SystemReport;
import com.dianping.cat.home.system.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.metric.service.MetricReportService;
import com.dianping.cat.report.page.statistics.service.SystemReportService;
import com.dianping.cat.report.page.statistics.task.system.SystemReportStatistics;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemReportBuilder
implements TaskBuilder {
    @Inject
    private SystemReportService m_reportService;
    @Inject
    protected MetricReportService m_metricReportService;
    @Inject
    private ProductLineConfigManager m_configManager;
    public static final String ID = "system";
    public static List<String> KEYS = Arrays.asList("cpuUsage");

    public boolean buildDailyTask(String name, String domain, Date period) {
        SystemReport report = this.buildSystemReport(period);
        DailyReport dailyReport = new DailyReport();
        dailyReport.setIp("");
        dailyReport.setDomain("cat");
        dailyReport.setCreationDate(new Date());
        dailyReport.setName(name);
        dailyReport.setPeriod(period);
        dailyReport.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((SystemReport)report);
        return this.m_reportService.insertDailyReport(dailyReport, binaryContent);
    }

    private SystemReport buildSystemReport(Date startTime) {
        long start = startTime.getTime();
        Date endTime = TimeHelper.addDays((Date)startTime, (int)1);
        long end = endTime.getTime();
        SystemReport report = new SystemReport();
        report.setStartTime(startTime);
        report.setEndTime(endTime);
        SystemReportStatistics statistics = new SystemReportStatistics(start, report, KEYS);
        for (String productLine : this.m_configManager.querySystemProductLines().keySet()) {
            for (long s = start; s < end; s += 3600000L) {
                Date sDate = new Date(s);
                Date eDate = new Date(s + 3600000L);
                try {
                    MetricReport r = (MetricReport)this.m_metricReportService.queryReport(productLine, sDate, eDate);
                    statistics.visitMetricReport(r);
                    continue;
                }
                catch (Exception e) {
                    Cat.logError((String)(productLine + " system report visitor error"), (Throwable)e);
                }
            }
        }
        return report;
    }

    public MetricReport querySystemReport(String product, Map<String, String> properties, Date start) {
        long time = start.getTime();
        Date end = new Date(time + 3600000L);
        MetricReport report = (MetricReport)this.m_metricReportService.queryReport(product, start, end);
        return report;
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException(this.getID() + " don't support hourly update");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException(this.getID() + " don't support monthly update");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException(this.getID() + " don't support weekly update");
    }

    private String getID() {
        return ID;
    }
}

