/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.system;

import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.consumer.metric.model.transform.BaseVisitor;
import com.dianping.cat.home.system.entity.Day;
import com.dianping.cat.home.system.entity.Domain;
import com.dianping.cat.home.system.entity.Entity;
import com.dianping.cat.home.system.entity.Rush;
import com.dianping.cat.home.system.entity.SystemReport;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemReportStatistics
extends BaseVisitor {
    private SystemReport m_systemReport;
    private List<String> m_keys;
    private String m_key;
    private String m_ip;
    private String m_productLine;
    private boolean m_rushHour;
    private long m_start;

    public SystemReportStatistics(long start, SystemReport systemReport, List<String> keys) {
        this.m_start = start;
        this.m_systemReport = systemReport;
        this.m_keys = keys;
    }

    public SystemReport getSystemReport() {
        return this.m_systemReport;
    }

    public void visitMetricItem(MetricItem metricItem) {
        String suffix = metricItem.getId().split(":")[2];
        String[] fields = suffix.split("_");
        this.m_key = fields[1];
        this.m_ip = fields[2];
        if (this.m_keys.contains(this.m_key)) {
            this.updateMachine("All");
            this.updateMachine(this.m_productLine);
            super.visitMetricItem(metricItem);
        }
    }

    private void updateMachine(String product) {
        Entity entity = this.m_systemReport.findOrCreateDomain(product).findOrCreateEntity(this.m_key);
        entity.findOrCreateMachine(this.m_ip);
    }

    public void visitSegment(Segment segment) {
        this.updateEntity(segment, "All");
        this.updateEntity(segment, this.m_productLine);
        super.visitSegment(segment);
    }

    private void updateEntity(Segment segment, String product) {
        Day day;
        Domain domain = this.m_systemReport.findOrCreateDomain(product);
        Entity entity = domain.findOrCreateEntity(this.m_key);
        if (this.m_rushHour) {
            Rush rush = entity.getRush();
            if (rush == null) {
                rush = new Rush();
                entity.setRush(rush);
            }
            rush.incCount((long)segment.getCount());
            rush.incSum(segment.getSum());
            rush.setAvg(rush.getSum() / (double)rush.getCount());
        }
        if ((day = entity.getDay()) == null) {
            day = new Day();
            entity.setDay(day);
        }
        day.incCount((long)segment.getCount());
        day.incSum(segment.getSum());
        day.setAvg(day.getSum() / (double)day.getCount());
    }

    public void visitMetricReport(MetricReport metricReport) {
        this.m_productLine = metricReport.getProduct();
        this.m_rushHour = false;
        if (this.isRushHour(metricReport.getStartTime(), metricReport.getEndTime())) {
            this.m_rushHour = true;
        }
        super.visitMetricReport(metricReport);
    }

    private boolean isRushHour(Date start, Date end) {
        return start.getTime() >= this.m_start + 57600000L && end.getTime() <= this.m_start + 64800000L;
    }
}

