/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.utilization;

import com.dianping.cat.consumer.transaction.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.Range;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.consumer.transaction.model.transform.BaseVisitor;
import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransactionReportVisitor
extends BaseVisitor {
    private String m_domain;
    private UtilizationReport m_report;
    private Set<String> m_types = new HashSet();
    private static final String MEMCACHED = "Cache.memcached";
    private static final String REDIS = "Cache.redis";
    private Map<Integer, Long> m_counts = new HashMap();

    public TransactionReportVisitor() {
        this.m_types.add("URL");
        this.m_types.add("Service");
        this.m_types.add("PigeonService");
        this.m_types.add("Call");
        this.m_types.add("PigeonCall");
        this.m_types.add("SQL");
        this.m_types.add(MEMCACHED);
        this.m_types.add(REDIS);
    }

    private void copyAttribute(TransactionType type, ApplicationState state) {
        long newTotal = state.getCount() + type.getTotalCount();
        if (newTotal > 0L) {
            state.setAvg95(((double)state.getCount() * state.getAvg95() + (double)type.getTotalCount() * type.getLine95Value()) / (double)newTotal);
        }
        state.setSum(state.getSum() + type.getSum());
        state.setFailureCount(state.getFailureCount() + type.getFailCount());
        state.setCount(newTotal);
        if (state.getCount() > 0L) {
            state.setFailurePercent((double)state.getFailureCount() * 1.0 / (double)state.getCount());
            state.setAvg(state.getSum() * 1.0 / (double)state.getCount());
        }
    }

    public TransactionReportVisitor setUtilizationReport(UtilizationReport report) {
        this.m_report = report;
        return this;
    }

    public void visitMachine(Machine machine) {
        String ip = machine.getIp();
        if ("All".equals(ip)) {
            super.visitMachine(machine);
        }
    }

    public void visitRange(Range range) {
        long count = range.getCount();
        int value = range.getValue();
        Long old = (Long)this.m_counts.get(value);
        if (old == null) {
            this.m_counts.put(value, count);
        } else {
            this.m_counts.put(value, count + old);
        }
    }

    public void visitTransactionReport(TransactionReport transactionReport) {
        this.m_domain = transactionReport.getDomain();
        super.visitTransactionReport(transactionReport);
    }

    public void visitType(TransactionType type) {
        String typeName = type.getId();
        Domain domain = this.m_report.findOrCreateDomain(this.m_domain);
        if ("Service".equals(typeName)) {
            typeName = "PigeonService";
        } else if ("Call".equals(typeName)) {
            typeName = "PigeonCall";
        } else if (typeName.startsWith(MEMCACHED)) {
            typeName = MEMCACHED;
        } else if (typeName.startsWith(REDIS)) {
            typeName = REDIS;
        }
        ApplicationState applicationState = null;
        if (this.m_types.contains(typeName)) {
            applicationState = domain.findOrCreateApplicationState(typeName);
            this.copyAttribute(type, applicationState);
        }
        super.visitType(type);
        if (applicationState != null) {
            long max = 0L;
            for (Map.Entry entry : this.m_counts.entrySet()) {
                long value = (Long)entry.getValue();
                if (value <= max) continue;
                max = value;
            }
            applicationState.setMaxQps((double)max * 1.0 / 300.0);
        }
        this.m_counts.clear();
    }
}

