/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.utilization;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.home.utilization.IVisitor;
import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import com.dianping.cat.home.utilization.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.cross.display.ProjectInfo;
import com.dianping.cat.report.page.cross.display.TypeDetailInfo;
import com.dianping.cat.report.page.cross.service.CrossReportService;
import com.dianping.cat.report.page.heartbeat.service.HeartbeatReportService;
import com.dianping.cat.report.page.statistics.service.UtilizationReportService;
import com.dianping.cat.report.page.statistics.task.utilization.HeartbeatReportVisitor;
import com.dianping.cat.report.page.statistics.task.utilization.TransactionReportVisitor;
import com.dianping.cat.report.page.statistics.task.utilization.UtilizationReportMerger;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.page.transaction.transform.TransactionMergeHelper;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;

public class UtilizationReportBuilder
implements TaskBuilder {
    public static final String ID = "utilization";
    @Inject
    protected UtilizationReportService m_reportService;
    @Inject
    protected TransactionReportService m_transactionReportService;
    @Inject
    protected HeartbeatReportService m_heartbeatReportService;
    @Inject
    protected CrossReportService m_crossReportService;
    @Inject
    private TransactionMergeHelper m_mergeHelper;
    @Inject
    private ServerFilterConfigManager m_configManger;

    public boolean buildDailyTask(String name, String domain, Date period) {
        UtilizationReport utilizationReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((UtilizationReport)utilizationReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    public boolean buildHourlyTask(String name, String domain, Date start) {
        UtilizationReport utilizationReport = new UtilizationReport("cat");
        Date end = new Date(start.getTime() + 3600000L);
        Set domains = this.m_reportService.queryAllDomainNames(start, end, "transaction");
        TransactionReportVisitor transactionVisitor = new TransactionReportVisitor().setUtilizationReport(utilizationReport);
        HeartbeatReportVisitor heartbeatVisitor = new HeartbeatReportVisitor().setUtilizationReport(utilizationReport);
        for (String domainName : domains) {
            if (!this.m_configManger.validateDomain(domainName)) continue;
            TransactionReport transactionReport = (TransactionReport)this.m_transactionReportService.queryReport(domainName, start, end);
            int size = transactionReport.getMachines().size();
            utilizationReport.findOrCreateDomain(domainName).setMachineNumber(size);
            transactionReport = this.m_mergeHelper.mergeAllMachines(transactionReport, "All");
            transactionVisitor.visitTransactionReport(transactionReport);
        }
        for (String domainName : domains) {
            if (!this.m_configManger.validateDomain(domainName)) continue;
            HeartbeatReport heartbeatReport = (HeartbeatReport)this.m_heartbeatReportService.queryReport(domainName, start, end);
            heartbeatVisitor.visitHeartbeatReport(heartbeatReport);
        }
        for (String domainName : domains) {
            if (!this.m_configManger.validateDomain(domainName)) continue;
            CrossReport crossReport = (CrossReport)this.m_crossReportService.queryReport(domainName, start, end);
            ProjectInfo projectInfo = new ProjectInfo(3600000L);
            projectInfo.setClientIp("All");
            projectInfo.visitCrossReport(crossReport);
            Collection callInfos = projectInfo.getCallProjectsInfo();
            for (TypeDetailInfo typeInfo : callInfos) {
                String project = typeInfo.getProjectName();
                if (this.validataService(project)) continue;
                long failure = typeInfo.getFailureCount();
                Domain d = utilizationReport.findOrCreateDomain(project);
                ApplicationState service = d.findApplicationState("PigeonService");
                if (service == null) continue;
                service.setFailureCount(service.getFailureCount() + failure);
                long count = service.getCount();
                if (count <= 0L) continue;
                service.setFailurePercent((double)service.getFailureCount() * 1.0 / (double)count);
            }
        }
        utilizationReport.setStartTime(start);
        utilizationReport.setEndTime(end);
        HourlyReport report = new HourlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(start);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((UtilizationReport)utilizationReport);
        return this.m_reportService.insertHourlyReport(report, binaryContent);
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        UtilizationReport utilizationReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((UtilizationReport)utilizationReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        UtilizationReport utilizationReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((UtilizationReport)utilizationReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private UtilizationReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        UtilizationReportMerger merger = new UtilizationReportMerger(new UtilizationReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                UtilizationReport reportModel = (UtilizationReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        UtilizationReport utilizationReport = merger.getUtilizationReport();
        utilizationReport.setStartTime(start);
        utilizationReport.setEndTime(end);
        return utilizationReport;
    }

    private UtilizationReport queryHourlyReportsByDuration(String name, String domain, Date start, Date end) {
        long endTime = end.getTime();
        UtilizationReportMerger merger = new UtilizationReportMerger(new UtilizationReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            Date date = new Date(startTime);
            UtilizationReport reportModel = (UtilizationReport)this.m_reportService.queryReport(domain, date, new Date(date.getTime() + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        UtilizationReport utilizationReport = merger.getUtilizationReport();
        utilizationReport.setStartTime(start);
        utilizationReport.setEndTime(end);
        return utilizationReport;
    }

    private boolean validataService(String projectName) {
        return projectName.equalsIgnoreCase("AllServers") || projectName.equalsIgnoreCase("UnknownProject");
    }
}

