/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage;

import com.dianping.cat.consumer.storage.model.entity.Machine;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.home.dal.report.Alteration;
import com.dianping.cat.home.storage.alert.entity.StorageAlertInfo;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.storage.Action;
import com.dianping.cat.report.page.storage.Context;
import com.dianping.cat.report.page.storage.config.StorageGroupConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.view.annotation.EntityMeta;
import org.unidal.web.mvc.view.annotation.ModelMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ModelMeta(value="storage")
public class Model
extends AbstractReportModel<Action, ReportPage, Context> {
    @EntityMeta
    private StorageReport m_originalReport;
    private StorageReport m_report;
    private Set<String> m_operations = new HashSet();
    private String m_countTrend;
    private String m_avgTrend;
    private String m_errorTrend;
    private String m_longTrend;
    private int m_minute;
    private List<Integer> m_minutes;
    private int m_maxMinute;
    private Date m_reportStart;
    private Date m_reportEnd;
    private Map<String, StorageAlertInfo> m_alertInfos;
    private Map<String, StorageGroupConfigManager.Department> m_departments;
    private Map<String, Map<String, List<String>>> m_links;
    private List<Alteration> m_alterations;
    private String m_distributionChart;

    public Model(Context ctx) {
        super((ActionContext)ctx);
    }

    public Map<String, StorageAlertInfo> getAlertInfos() {
        return this.m_alertInfos;
    }

    public List<Alteration> getAlterations() {
        return this.m_alterations;
    }

    public String getAvgTrend() {
        return this.m_avgTrend;
    }

    public String getCountTrend() {
        return this.m_countTrend;
    }

    public List<String> getCurrentOperations() {
        if (this.m_report != null) {
            ArrayList<String> ops = new ArrayList<String>(this.m_report.getOps());
            Collections.sort(ops);
            return ops;
        }
        return new ArrayList<String>();
    }

    public Action getDefaultAction() {
        return Action.HOURLY_STORAGE;
    }

    public Map<String, StorageGroupConfigManager.Department> getDepartments() {
        return this.m_departments;
    }

    public String getDistributionChart() {
        return this.m_distributionChart;
    }

    public String getDomain() {
        return this.getDisplayDomain();
    }

    public Collection<String> getDomains() {
        return new HashSet<String>();
    }

    public String getErrorTrend() {
        return this.m_errorTrend;
    }

    public List<String> getIps() {
        if (this.m_report == null) {
            return new ArrayList<String>();
        }
        return SortHelper.sortIpAddress((Collection)this.m_report.getIps());
    }

    public Map<String, Map<String, List<String>>> getLinks() {
        return this.m_links;
    }

    public String getLongTrend() {
        return this.m_longTrend;
    }

    public Machine getMachine() {
        Machine m;
        Machine machine = new Machine();
        if (this.m_report != null && (m = (Machine)this.m_report.getMachines().get(this.getIpAddress())) != null) {
            machine = m;
        }
        return machine;
    }

    public int getMaxMinute() {
        return this.m_maxMinute;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public List<Integer> getMinutes() {
        return this.m_minutes;
    }

    public List<String> getOperations() {
        ArrayList<String> operations = new ArrayList<String>(this.m_operations);
        Collections.sort(operations);
        return operations;
    }

    public StorageReport getOriginalReport() {
        return this.m_originalReport;
    }

    public StorageReport getReport() {
        return this.m_report;
    }

    public Date getReportEnd() {
        return this.m_reportEnd;
    }

    public Date getReportStart() {
        return this.m_reportStart;
    }

    public void setAlertInfos(Map<String, StorageAlertInfo> alertInfos) {
        this.m_alertInfos = alertInfos;
    }

    public void setAlterations(List<Alteration> alterations) {
        this.m_alterations = alterations;
    }

    public void setAvgTrend(String avgTrend) {
        this.m_avgTrend = avgTrend;
    }

    public void setCountTrend(String countTrend) {
        this.m_countTrend = countTrend;
    }

    public void setDepartments(Map<String, StorageGroupConfigManager.Department> departments) {
        this.m_departments = departments;
    }

    public void setDistributionChart(String distributionChart) {
        this.m_distributionChart = distributionChart;
    }

    public void setErrorTrend(String errorTrend) {
        this.m_errorTrend = errorTrend;
    }

    public void setLinks(Map<String, Map<String, List<String>>> links) {
        this.m_links = links;
    }

    public void setLongTrend(String longTrend) {
        this.m_longTrend = longTrend;
    }

    public void setMaxMinute(int maxMinute) {
        this.m_maxMinute = maxMinute;
    }

    public void setMinute(int minute) {
        this.m_minute = minute;
    }

    public void setMinutes(List<Integer> minutes) {
        this.m_minutes = minutes;
    }

    public void setOperations(Set<String> operations) {
        this.m_operations = operations;
    }

    public void setOriginalReport(StorageReport originalReport) {
        this.m_originalReport = originalReport;
    }

    public void setReport(StorageReport report) {
        this.m_report = report;
    }

    public void setReportEnd(Date reportEnd) {
        this.m_reportEnd = reportEnd;
    }

    public void setReportStart(Date reportStart) {
        this.m_reportStart = reportStart;
    }
}

