/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.task;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.storage.StorageReportMerger;
import com.dianping.cat.consumer.storage.model.IVisitor;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.consumer.storage.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentEntity;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentEntity;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageReportService
extends AbstractReportService<StorageReport> {
    public StorageReport makeReport(String id, Date start, Date end) {
        StorageReport report = new StorageReport(id);
        int index = id.lastIndexOf("-");
        String name = id.substring(0, index);
        String type = id.substring(index + 1);
        report.setName(name).setType(type);
        report.setStartTime(start).setEndTime(end);
        return report;
    }

    public StorageReport queryDailyReport(String id, Date start, Date end) {
        StorageReportMerger merger = new StorageReportMerger(new StorageReport(id));
        long endTime = end.getTime();
        String name = "storage";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(id, name, new Date(startTime), DailyReportEntity.READSET_FULL);
                StorageReport reportModel = this.queryFromDailyBinary(report.getId(), id);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (DalNotFoundException report) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        StorageReport storageReport = merger.getStorageReport();
        storageReport.setStartTime(start);
        storageReport.setEndTime(end);
        return storageReport;
    }

    private StorageReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new StorageReport(domain);
    }

    private StorageReport queryFromHourlyBinary(int id, String reportId) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, HourlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new StorageReport(reportId);
    }

    private StorageReport queryFromMonthlyBinary(int id, String reportId) throws DalException {
        MonthlyReportContent content = this.m_monthlyReportContentDao.findByPK(id, MonthlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new StorageReport(reportId);
    }

    private StorageReport queryFromWeeklyBinary(int id, String reportId) throws DalException {
        WeeklyReportContent content = this.m_weeklyReportContentDao.findByPK(id, WeeklyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new StorageReport(reportId);
    }

    public StorageReport queryHourlyReport(String reportId, Date start, Date end) {
        StorageReportMerger merger = new StorageReportMerger(new StorageReport(reportId));
        long endTime = end.getTime();
        String name = "storage";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), reportId, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    StorageReport reportModel = this.queryFromHourlyBinary(report.getId(), reportId);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        StorageReport storageReport = merger.getStorageReport();
        storageReport.setStartTime(start);
        storageReport.setEndTime(new Date(end.getTime() - 1L));
        Set ids = this.queryAllIds(start, end, name, reportId);
        storageReport.getIds().addAll(ids);
        return storageReport;
    }

    private Set<String> queryAllIds(Date start, Date end, String name, String reportId) {
        HashSet<String> ids = new HashSet<String>();
        String type = reportId.substring(reportId.lastIndexOf("-"));
        for (String myId : this.queryAllDomainNames(start, end, name)) {
            if (!myId.endsWith(type)) continue;
            String prefix = myId.substring(0, myId.lastIndexOf("-"));
            ids.add(prefix);
        }
        return ids;
    }

    public StorageReport queryMonthlyReport(String reportId, Date start) {
        try {
            MonthlyReport entity = this.m_monthlyReportDao.findReportByDomainNamePeriod(start, reportId, "storage", MonthlyReportEntity.READSET_FULL);
            return this.queryFromMonthlyBinary(entity.getId(), reportId);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new StorageReport(reportId);
    }

    public StorageReport queryWeeklyReport(String reportId, Date start) {
        try {
            WeeklyReport entity = this.m_weeklyReportDao.findReportByDomainNamePeriod(start, reportId, "storage", WeeklyReportEntity.READSET_FULL);
            return this.queryFromWeeklyBinary(entity.getId(), reportId);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new StorageReport(reportId);
    }
}

