/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.topology;

import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.dal.report.Alert;
import com.dianping.cat.home.storage.alert.entity.Detail;
import com.dianping.cat.home.storage.alert.entity.Machine;
import com.dianping.cat.home.storage.alert.entity.Operation;
import com.dianping.cat.home.storage.alert.entity.Storage;
import com.dianping.cat.home.storage.alert.entity.StorageAlertInfo;
import com.dianping.cat.home.storage.alert.entity.Target;
import com.dianping.cat.report.alert.sender.AlertEntity;
import com.dianping.cat.report.alert.storage.AbstractStorageAlert;
import com.dianping.cat.report.page.storage.topology.StorageAlertInfoRTContainer;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageAlertInfoBuilder {
    @Inject
    private StorageAlertInfoRTContainer m_container;

    public int buildLevel(int level, int other) {
        return level > other ? level : other;
    }

    public StorageAlertInfo getAlertInfo(String type, int minute) {
        long current = TimeHelper.getCurrentHour().getTime() + (long)minute * 60000L;
        return this.m_container.findOrCreate(type, current);
    }

    public Map<Long, StorageAlertInfo> buildStorageAlertInfos(List<Alert> alerts) {
        LinkedHashMap<Long, StorageAlertInfo> alertInfos = new LinkedHashMap<Long, StorageAlertInfo>();
        for (Alert alert : alerts) {
            long time = alert.getAlertTime().getTime();
            long current = time - time % 60000L - 60000L;
            StorageAlertInfo alertInfo = (StorageAlertInfo)alertInfos.get(current);
            if (alertInfo == null) {
                alertInfo = this.m_container.makeAlertInfo(alert.getCategory(), new Date(current));
                alertInfos.put(current, alertInfo);
            }
            this.parseAlertEntity(alert, alertInfo);
        }
        return alertInfos;
    }

    public void parseAlertEntity(Alert alert, StorageAlertInfo alertInfo) {
        String name = alert.getDomain();
        List fields = Splitters.by((String)";").split(alert.getMetric());
        String ip = (String)fields.get(0);
        String operation = (String)fields.get(1);
        String target = this.queryTargetTitle((String)fields.get(2));
        int level = this.queryLevel(alert.getType());
        Storage storage = alertInfo.findOrCreateStorage(name);
        storage.incCount();
        storage.setLevel(this.buildLevel(storage.getLevel(), level));
        Machine machine = storage.findOrCreateMachine(ip);
        machine.incCount();
        machine.setLevel(this.buildLevel(machine.getLevel(), level));
        Operation op = machine.findOrCreateOperation(operation);
        op.incCount();
        op.setLevel(this.buildLevel(op.getLevel(), level));
        Target tg = op.findOrCreateTarget(target);
        tg.incCount();
        tg.setLevel(this.buildLevel(tg.getLevel(), level));
        tg.getDetails().add(new Detail(alert.getContent()).setLevel(level));
    }

    public void processAlertEntity(String type, int minute, AlertEntity entity, AbstractStorageAlert.ReportFetcherParam param) {
        int level = this.queryLevel(entity.getLevel());
        String name = param.getName();
        String ip = param.getMachine();
        String opertaion = param.getMethod();
        String target = this.queryTargetTitle(param.getTarget());
        Storage storage = this.getAlertInfo(type, minute).findOrCreateStorage(name);
        storage.incCount();
        storage.setLevel(this.buildLevel(storage.getLevel(), level));
        Machine machine = storage.findOrCreateMachine(ip);
        machine.incCount();
        machine.setLevel(this.buildLevel(machine.getLevel(), level));
        Operation op = machine.findOrCreateOperation(opertaion);
        op.incCount();
        op.setLevel(this.buildLevel(op.getLevel(), level));
        Target tg = op.findOrCreateTarget(target);
        tg.incCount();
        tg.setLevel(this.buildLevel(tg.getLevel(), level));
        tg.getDetails().add(new Detail(entity.getContent()).setLevel(level));
    }

    private int queryLevel(String level) {
        if ("error".equals(level)) {
            return 2;
        }
        if ("warning".equals(level)) {
            return 1;
        }
        return 0;
    }

    private String queryTargetTitle(String target) {
        if ("avg".equals(target)) {
            return "\u54cd\u5e94\u65f6\u95f4";
        }
        if ("error".equals(target)) {
            return "\u9519\u8bef\u6570";
        }
        if ("errorPercent".equals(target)) {
            return "\u9519\u8bef\u7387";
        }
        return target;
    }
}

