/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.topology;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.home.dal.report.AlertDao;
import com.dianping.cat.home.dal.report.AlertEntity;
import com.dianping.cat.home.storage.alert.entity.StorageAlertInfo;
import com.dianping.cat.report.page.storage.Model;
import com.dianping.cat.report.page.storage.Payload;
import com.dianping.cat.report.page.storage.topology.StorageAlertInfoBuilder;
import com.dianping.cat.report.page.storage.topology.StorageAlertInfoManager;
import com.dianping.cat.report.page.storage.topology.StorageAlertInfoRTContainer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageAlertInfoManager
implements Initializable {
    @Inject
    private ServerConfigManager m_serverConfigManager;
    @Inject
    private AlertDao m_alertDao;
    @Inject
    private StorageAlertInfoBuilder m_builder;
    private StorageAlertInfoRTContainer m_alertInfoRTContainer;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("HH:mm");

    private void checkAlertInfos(Map<String, StorageAlertInfo> results, long start, long end, Payload payload) {
        if (results.size() < payload.getMinuteCounts()) {
            for (long s = start; s <= end; s += 60000L) {
                String title = this.m_sdf.format(new Date(s));
                if (results.containsKey(title)) continue;
                StorageAlertInfo blankAlertInfo = new StorageAlertInfo(payload.getType());
                results.put(title, blankAlertInfo);
            }
        }
    }

    private Map<String, StorageAlertInfo> convertAlertInfo(Map<Long, StorageAlertInfo> alertInfos, int tops) {
        LinkedHashMap<String, StorageAlertInfo> results = new LinkedHashMap<String, StorageAlertInfo>();
        for (Map.Entry<Long, StorageAlertInfo> alertInfo : alertInfos.entrySet()) {
            StorageAlertInfo alert = alertInfo.getValue();
            List tmp = new ArrayList(alert.getStorages().entrySet());
            Collections.sort(tmp, new AlertInfoStorageComparator());
            if (tmp.size() > tops) {
                tmp = tmp.subList(0, tops);
            }
            StorageAlertInfo result = this.m_alertInfoRTContainer.makeAlertInfo(alert.getId(), alert.getStartTime());
            Map storages = result.getStorages();
            for (Map.Entry storage : tmp) {
                storages.put(storage.getKey(), storage.getValue());
            }
            results.put(this.m_sdf.format(new Date(alertInfo.getKey())), result);
        }
        return results;
    }

    public void initialize() throws InitializationException {
        if (this.m_serverConfigManager.isAlertMachine()) {
            Threads.forGroup((String)"cat").start((Runnable)new StorageAlerInfoLoadTask(this));
        }
    }

    private Map<String, StorageAlertInfo> queryAlertInfos(long start, long end, int tops, String type) {
        LinkedHashMap alertInfos = new LinkedHashMap();
        Pair pair = this.queryFromMemory(start, end, type);
        List historyTimes = (List)pair.getValue();
        alertInfos.putAll((Map)pair.getKey());
        if (historyTimes.size() > 0) {
            Date historyStart = new Date((Long)historyTimes.get(0) + 60000L);
            Date historyEnd = new Date((Long)historyTimes.get(historyTimes.size() - 1) + 120000L - 1000L);
            try {
                List alerts = this.m_alertDao.queryAlertsByTimeCategory(historyStart, historyEnd, type, AlertEntity.READSET_FULL);
                alertInfos.putAll(this.m_builder.buildStorageAlertInfos(alerts));
            }
            catch (DalNotFoundException alerts) {
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return this.convertAlertInfo(alertInfos, tops);
    }

    public Map<String, StorageAlertInfo> queryAlertInfos(Payload payload, Model model) {
        int minuteCounts = payload.getMinuteCounts();
        long end = payload.getDate() + (long)model.getMinute() * 60000L;
        long start = end - (long)(minuteCounts - 1) * 60000L;
        LinkedHashMap<String, StorageAlertInfo> results = new LinkedHashMap<String, StorageAlertInfo>();
        Map alertInfos = this.queryAlertInfos(start, end, payload.getTopCounts(), payload.getType());
        this.checkAlertInfos(alertInfos, start, end, payload);
        ArrayList keys = new ArrayList(alertInfos.keySet());
        Collections.sort(keys, new StringCompartor());
        for (String key : keys) {
            results.put(key, (StorageAlertInfo)alertInfos.get(key));
        }
        return results;
    }

    public Pair<Map<Long, StorageAlertInfo>, List<Long>> queryFromMemory(long start, long end, String type) {
        LinkedHashMap<Long, StorageAlertInfo> alertInfos = new LinkedHashMap<Long, StorageAlertInfo>();
        LinkedList<Long> historyMinutes = new LinkedList<Long>();
        Set timeKeys = this.m_alertInfoRTContainer.queryExistingMinutes(type);
        long earliest = Long.MAX_VALUE;
        if (!timeKeys.isEmpty()) {
            earliest = (Long)Collections.min(timeKeys);
        }
        for (long s = start; s <= end; s += 60000L) {
            StorageAlertInfo alertInfo = this.m_alertInfoRTContainer.find(type, s);
            if (alertInfo != null) {
                alertInfos.put(s, alertInfo);
                continue;
            }
            if (s >= earliest) continue;
            historyMinutes.add(s);
        }
        return new Pair(alertInfos, historyMinutes);
    }

    static /* synthetic */ AlertDao access$000(StorageAlertInfoManager x0) {
        return x0.m_alertDao;
    }

    static /* synthetic */ StorageAlertInfoBuilder access$100(StorageAlertInfoManager x0) {
        return x0.m_builder;
    }

    static /* synthetic */ StorageAlertInfoRTContainer access$200(StorageAlertInfoManager x0) {
        return x0.m_alertInfoRTContainer;
    }
}

