/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.topology;

import com.dianping.cat.home.storage.alert.entity.StorageAlertInfo;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageAlertInfoRTContainer
implements Initializable {
    public static final int SIZE = 60;
    private Map<String, Map<Long, StorageAlertInfo>> m_alertInfos = new HashMap();

    public StorageAlertInfo find(String type, long time) {
        Map alert = (Map)this.m_alertInfos.get(type);
        if (alert != null) {
            return (StorageAlertInfo)alert.get(time);
        }
        return null;
    }

    public Set<Long> queryExistingMinutes(String type) {
        Map alert = (Map)this.m_alertInfos.get(type);
        if (alert != null) {
            return alert.keySet();
        }
        return Collections.emptySet();
    }

    public StorageAlertInfo findOrCreate(String type, long time) {
        Map alertInfo = (Map)this.m_alertInfos.get(type);
        if (alertInfo != null) {
            StorageAlertInfo report = (StorageAlertInfo)alertInfo.get(time);
            if (report == null) {
                report = this.makeAlertInfo(type, new Date(time));
                alertInfo.put(time, report);
            }
            return report;
        }
        return this.makeAlertInfo(type, new Date(time));
    }

    public boolean offer(String type, StorageAlertInfo alertInfo) {
        boolean ret = false;
        long time = alertInfo.getStartTime().getTime();
        Map alert = (Map)this.m_alertInfos.get(type);
        if (alert != null && !alert.containsKey(time)) {
            alert.put(time, alertInfo);
            ret = true;
        }
        return ret;
    }

    public StorageAlertInfo makeAlertInfo(String id, Date start) {
        StorageAlertInfo alertInfo = new StorageAlertInfo(id);
        alertInfo.setStartTime(start);
        alertInfo.setEndTime(new Date(start.getTime() + 60000L - 1L));
        return alertInfo;
    }

    public void initialize() throws InitializationException {
        Map sqlAlerts = Collections.synchronizedMap(new /* Unavailable Anonymous Inner Class!! */);
        Map cacheAlerts = Collections.synchronizedMap(new /* Unavailable Anonymous Inner Class!! */);
        this.m_alertInfos.put("SQL", sqlAlerts);
        this.m_alertInfos.put("Cache", cacheAlerts);
    }
}

