/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.transform;

import com.dianping.cat.consumer.storage.model.entity.Domain;
import com.dianping.cat.consumer.storage.model.entity.Machine;
import com.dianping.cat.consumer.storage.model.entity.Operation;
import com.dianping.cat.consumer.storage.model.entity.Segment;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.consumer.storage.model.transform.BaseVisitor;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.storage.StorageConstants;
import com.dianping.cat.report.page.storage.transform.HourlyLineChartVisitor;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HourlyLineChartVisitor
extends BaseVisitor {
    private String m_ip;
    private Map<String, LineChart> m_lineCharts = new LinkedHashMap();
    private Date m_start;
    private Map<String, LineChartData> m_datas = new LinkedHashMap();
    private static final int SIZE = 60;
    private String m_domain;
    private String m_currentOperation;

    public HourlyLineChartVisitor(String ip, String domain, Set<String> operations, Date start) {
        this.m_ip = ip;
        this.m_domain = domain;
    }

    private Map<Integer, Double> buildAvgData(Map<Integer, Double> counts, Map<Integer, Double> sums) {
        LinkedHashMap<Integer, Double> values = new LinkedHashMap<Integer, Double>();
        for (Map.Entry<Integer, Double> entry : counts.entrySet()) {
            int minute = entry.getKey();
            Double count = counts.get(minute);
            Double sum = sums.get(minute);
            if (count == null || !(count > 0.0) || sum == null || !(sum > 0.0)) continue;
            values.put(minute, sum / count);
        }
        return values;
    }

    private void buildLineChart(long size, String key, String title, Map<Integer, Double> values) {
        Double[] value = new Double[60];
        int i = 0;
        while ((long)i < size) {
            value[i] = 0.0;
            ++i;
        }
        for (i = 0; i < 60; ++i) {
            Double temp = values.get(i);
            if (temp == null) continue;
            value[i] = temp;
        }
        ((LineChart)this.m_lineCharts.get(title)).add(key, value);
    }

    public Map<String, LineChart> getLineChart() {
        long minute = System.currentTimeMillis() / 1000L / 60L % 60L;
        long current = System.currentTimeMillis();
        current -= current % 3600000L;
        long size = (int)minute + 1;
        if (this.m_start.getTime() < current) {
            size = 60L;
        }
        for (Map.Entry entry : this.m_datas.entrySet()) {
            String key = (String)entry.getKey();
            LineChartData data = (LineChartData)entry.getValue();
            this.buildLineChart(size, key, "count", data.getCounts());
            this.buildLineChart(size, key, "avg", this.buildAvgData(data.getCounts(), data.getSums()));
            this.buildLineChart(size, key, "error", data.getErrors());
            this.buildLineChart(size, key, "long", data.getLongs());
        }
        return this.m_lineCharts;
    }

    public void visitDomain(Domain domain) {
        if (StringUtils.isEmpty((String)this.m_domain) || this.m_domain.equals(domain.getId())) {
            super.visitDomain(domain);
        }
    }

    public void visitMachine(Machine machine) {
        if (StringUtils.isEmpty((String)this.m_ip) || this.m_ip.equals(machine.getId())) {
            super.visitMachine(machine);
        }
    }

    public void visitOperation(Operation operation) {
        this.m_currentOperation = operation.getId();
        super.visitOperation(operation);
    }

    public void visitSegment(Segment segment) {
        int minute = segment.getId();
        LineChartData data = (LineChartData)this.m_datas.get(this.m_currentOperation);
        data.incCounts(minute, segment.getCount());
        data.incSums(minute, segment.getSum());
        data.incErrors(minute, segment.getError());
        data.incLongs(minute, segment.getLongCount());
    }

    public void visitStorageReport(StorageReport storageReport) {
        this.m_start = storageReport.getStartTime();
        for (String title : StorageConstants.TITLES) {
            LineChart linechart = new LineChart();
            linechart.setSize(60);
            linechart.setStep(60000L);
            linechart.setStart(this.m_start);
            this.m_lineCharts.put(title, linechart);
        }
        for (String operation : storageReport.getOps()) {
            LineChartData data = new LineChartData(operation);
            this.m_datas.put(operation, data);
        }
        super.visitStorageReport(storageReport);
    }
}

