/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.system;

import com.dianping.cat.consumer.config.ProductLineConfig;
import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.system.Action;
import com.dianping.cat.report.page.system.Context;
import com.dianping.cat.report.page.system.Handler;
import com.dianping.cat.report.page.system.JspViewer;
import com.dianping.cat.report.page.system.Model;
import com.dianping.cat.report.page.system.Payload;
import com.dianping.cat.report.page.system.graph.SystemGraphCreator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private SystemGraphCreator m_graphCreator;
    @Inject
    private ProductLineConfigManager m_productLineManager;

    public List<String> buildProductlines() {
        ArrayList<String> productlines = new ArrayList<String>();
        Set keys = this.m_productLineManager.querySystemProductLines().keySet();
        String prefix = (String)ProductLineConfig.SYSTEM.getPrefix().get(0);
        int index = prefix.length();
        for (String productline : keys) {
            productlines.add(productline.substring(index, productline.length()));
        }
        return productlines;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="system")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="system")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        HashMap<String, String> pars = new HashMap<String, String>();
        pars.put("ip", payload.getIpAddrs());
        pars.put("type", payload.getType());
        pars.put("metricType", "systemMonitor");
        this.normalize(model, payload);
        String domain = payload.getDomain();
        String productLine = this.m_productLineManager.querySystemProductLine(domain);
        long start = payload.getHistoryStartDate().getTime();
        long end = payload.getHistoryEndDate().getTime();
        start -= start % 3600000L;
        end -= end % 3600000L;
        Date startDate = new Date(start);
        Date endDate = new Date(end);
        model.setStartTime(startDate);
        model.setEndTime(endDate);
        switch (1.$SwitchMap$com$dianping$cat$report$page$system$Action[action.ordinal()]) {
            case 1: {
                HashSet ipAddrs = new HashSet();
                Map charts = this.m_graphCreator.buildChartsByProductLine(productLine, pars, ipAddrs, startDate, endDate);
                model.setLineCharts(new ArrayList(charts.values()));
                model.setIpAddrs(ipAddrs);
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        model.setProductLines(this.buildProductlines());
        model.setPage((Page)ReportPage.SYSTEM);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
    }
}

